#version 150

const float M_PI=3.14159265358979323846;
const float aThreshold=0.15;
const vec4 color1=vec4(0.0,0.0,0.0,1);;
const vec4 color3=vec4(0.0,0.0,0.0,1);
const vec4 color2=vec4(0.0,0.0,0.0,1);;

const float aBright=0.8f;
const float aVariation=1.0f-aBright;

in float theta;
in float phi;

#include "shared/ShaderFInterface.glsl"
#include "shared/ShaderFFunctions.glsl"

void main(void) {
 
  vec3 aP;
  vec4 color11;
  
  float aX=theta*100;
  float aY=phi*100;

  aP.x=floor(aX);
  aP.y=floor(aY);
  aP.z=0;
  
  float aR=randp(aP);
  
  if(aR>0.97){
    float afX=fract(aX);
    float afY=fract(aY);
    float adX=afX-abs(randp(aP+0.5))*0.3f;
    float adY=afY-abs(randp(aP+0.25))*0.3f;
    float aD=sqrt(adX*adX+adY*adY);

    color11=vec4(aBright+randp(aP+0.2)*aVariation,
      aBright+randp(aP+0.3)*aVariation,
      aBright+randp(aP+0.4)*aVariation,1);
  
    if (aD<=aThreshold){
      aR=aD/aThreshold;
      
      out_Color =mix(color11,color3,aR);
    }
    else{
      out_Color =vec4(0,0,0,1);
    }
  }
  else{
    out_Color =vec4(0,0,0,1);
  }
}	
