#include "shared/shaderVHeaderBase.glsl"

const float R=2000;
out float theta;
out float phi;

void main()
{
	// position in object ref
	position.x=R*cos(in_Position.y)*cos(in_Position.x);
	position.y=R*cos(in_Position.y)*sin(in_Position.x);
	position.z=R*sin(in_Position.y);
	
	// position in view
	vec4 p= modelview*refObject*vec4(position,0);
	p.w=1;
	
	// position in camera
	gl_Position = projection * p;

  theta=in_Position.x;
  phi=in_Position.y;
}

