#version 150

vec4 color1;
vec4 color2;

flat in int materialIndex;

uniform vec4 colors[6];

//=vec4[6](vec4(1,0.2,0.2,1),
//                              vec4(0.2,0,0,0.5),
//                              vec4(0.2,1,0.2,1),
//                              vec4(0,0.2,0,0.5),
 //                             vec4(0.2,0.2,1,1),
 //                             vec4(0,0,0.2,0.5));

#include "shared/ShaderFInterface.glsl"
#include "shared/ShaderFFunctions.glsl"

void main(void) {
  color1=colors[2*materialIndex];
  color2=colors[2*materialIndex+1];

  float fogin=clamp(fog,0,1);
  
  switch(materialIndex){
    case 0:
      float noise=noiseA(position);
      out_Color =clamp((mix(fogcolor,I*mixColor(noise),fogin)),0,1);
      break;
    case 1:
      out_Color =clamp((mix(fogcolor,I*marble(position),fogin)),0,1);
      break;
    case 2:
      out_Color =clamp((mix(fogcolor,I*marbleWoody(position),fogin)),0,1);
      break;
  }
  
  //out_Color =vec4(materialIndex/2.0f,1,0,1);
}	
