#include "shared/shaderVHeaderBase.glsl"

void main()
{
  // normal in scene
	vec4 normalExt=refObject * vec4(in_Normal,0);
	normal=normalExt.xyz;
	normal=normalize(normal);
	
	// position in object ref
	position=in_Position;
	// position in scene
	vec4 p=refObject*vec4(position,1);
	
	// position in camera
	gl_Position = projection * modelview * p;

  // compute reflection at position
  vec3 aR=reflect(light,normal);
  aR=normalize(aR);
  // compute direction of camera at point p in scene
  vec3 aV=camera-p.xyz;
  aV=normalize(aV);
		
  // compute light
  float Id1=-dot(light,normal);
  float Id2=phong.y*max(Id1,0);
  
  float Is1=dot(aV,aR);
  Is1=pow(max(Is1,0),phong.w);
  float Is2=phong.z*Is1;
  
  float I1=phong.x+Is2+Id2;
  I=max(I1,0);

  float d=length(gl_Position);
	fog=(d-fogend)/(fogstart-fogend);
}

