/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.launcher;

import com.xuarig.launcher.Location;
import com.xuarig.launcher.LocationManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class Component {
    protected LocationManager locationManager = null;
    protected String name;
    protected String temp;
    protected long codeBuild;
    protected String subPath;
    protected boolean isPrepared = false;
    protected boolean isFailed = false;

    public LocationManager getLocationManager() {
        return this.locationManager;
    }

    public void setLocationManager(LocationManager locationManager) {
        this.locationManager = locationManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCodeBuild() {
        return this.codeBuild;
    }

    public void setCodeBuild(long codeBuild) {
        this.codeBuild = codeBuild;
    }

    public String getSubPath() {
        return this.subPath;
    }

    public void setSubPath(String path) {
        this.subPath = path;
    }

    public void setTemp(String aTemp) {
        this.temp = aTemp;
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public void setPrepared(boolean isPrepared) {
        this.isPrepared = isPrepared;
    }

    public boolean isFailed() {
        return this.isFailed;
    }

    public void setFailed(boolean isFailed) {
        this.isFailed = isFailed;
    }

    public boolean prepare() {
        byte[] buffer = new byte[16384];
        Location aRemote = this.locationManager.getRemote();
        this.setPrepared(true);
        InputStream aIn = aRemote.getInputStream(this.getName());
        if (aIn == null) {
            this.setFailed(true);
            return false;
        }
        File aFile = new File(String.valueOf(this.temp) + "/" + this.getName());
        try {
            int bytesRead;
            FileOutputStream aOut = new FileOutputStream(aFile);
            while ((bytesRead = aIn.read(buffer)) != -1) {
                ((OutputStream)aOut).write(buffer, 0, bytesRead);
            }
            aIn.close();
            ((OutputStream)aOut).close();
        }
        catch (Exception aE) {
            this.setFailed(true);
            return false;
        }
        this.setFailed(false);
        return true;
    }

    public boolean rollback() {
        this.setPrepared(false);
        this.setFailed(false);
        return false;
    }

    public boolean install() {
        Location aLocal = this.locationManager.getLocal();
        CopyOption[] options = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
        Path aPathSource = Paths.get(String.valueOf(this.temp) + "/" + this.getName(), new String[0]);
        Path aPathTarget = Paths.get(String.valueOf(aLocal.getPath()) + "/" + this.getName(), new String[0]);
        try {
            Files.move(aPathSource, aPathTarget, options);
        }
        catch (IOException e) {
            this.setFailed(true);
            return false;
        }
        return true;
    }

    public String toString() {
        String aString = String.valueOf(this.name) + ";" + this.codeBuild + ";" + this.subPath;
        return aString;
    }

    public static Component build(String aDefinitionLine) {
        String[] aCut = aDefinitionLine.split(";");
        if (aCut.length != 3) {
            return null;
        }
        long aCodeBuild = 0L;
        try {
            aCodeBuild = Long.parseLong(aCut[1]);
        }
        catch (Exception aE) {
            return null;
        }
        Component aComponent = new Component();
        aComponent.setName(aCut[0]);
        aComponent.setCodeBuild(aCodeBuild);
        aComponent.setSubPath(aCut[2]);
        return aComponent;
    }

    public static void main(String[] args) {
        Component aComponent = new Component();
        aComponent.setCodeBuild(21211121L);
        aComponent.setName("BlockEngine.jar");
        aComponent.setSubPath("root//subpath1//subpath2");
        String aString1 = aComponent.toString();
        System.out.println(aString1);
        Component aComponent2 = Component.build(aString1);
        String aString2 = aComponent2.toString();
        System.out.println(aString2);
    }
}

