/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.launcher;

import com.xuarig.launcher.LaunchDetacher;
import com.xuarig.launcher.LocationManager;
import com.xuarig.launcher.Release;
import javax.swing.JOptionPane;

public abstract class Launcher {
    String applicationName;
    String releaseDefinitionName = "Version.def";
    Release oldRelease = new Release();
    Release newRelease = new Release();
    Release deltaRelease = null;
    LocationManager locationManager = new LocationManager();

    protected abstract void setup();

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getReleaseDefinitionName() {
        return this.releaseDefinitionName;
    }

    public void setReleaseDefinitionName(String releaseDefinitionName) {
        this.releaseDefinitionName = releaseDefinitionName;
    }

    public void LaunchWithCheck() {
        boolean mustInstall = false;
        this.checkVersion();
        if (this.deltaRelease != null) {
            mustInstall = this.requestForUpdate();
        }
        if (mustInstall) {
            this.installNovelties();
        }
        this.launch();
    }

    private boolean requestForUpdate() {
        int n = JOptionPane.showConfirmDialog(null, "Une nouvelle version est diponible.\nVoulez-vous mettre \u00e0 jour votre logiciel ?", "Gestion de version", 0);
        return n == 0;
    }

    public void launch() {
        LaunchDetacher aDetacher = new LaunchDetacher();
        aDetacher.run();
    }

    protected void checkVersion() {
        this.oldRelease.setLocationManager(this.locationManager);
        this.oldRelease.setDefinitionName(this.releaseDefinitionName);
        this.oldRelease.updateLocal();
        this.newRelease.setLocationManager(this.locationManager);
        this.newRelease.setDefinitionName(this.releaseDefinitionName);
        this.newRelease.updateRemote();
        this.deltaRelease = this.newRelease.getNovelties(this.oldRelease);
        if (this.deltaRelease != null) {
            this.deltaRelease.setLocationManager(this.locationManager);
            this.deltaRelease.setDefinitionName(this.releaseDefinitionName);
        }
    }

    protected boolean installNovelties() {
        if (this.deltaRelease.prepare()) {
            return this.deltaRelease.install();
        }
        return false;
    }
}

