/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.launcher;

import com.xuarig.launcher.Component;
import com.xuarig.launcher.Location;
import com.xuarig.launcher.LocationDirectory;
import com.xuarig.launcher.LocationManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Release {
    protected static final String tempPath = "temp";
    protected String definitionName;
    protected Map<String, Component> components = new HashMap<String, Component>();
    protected boolean isPrepared = false;
    protected LocationManager locationManager = null;

    public String getDefinitionName() {
        return this.definitionName;
    }

    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public void addComponent(Component aComponent) {
        aComponent.setLocationManager(this.locationManager);
        this.components.put(aComponent.getName(), aComponent);
    }

    public Release getNovelties(Release oldRelease) {
        HashMap<String, Component> aNovelties = new HashMap<String, Component>();
        Collection<Component> aCollection = this.components.values();
        Release aDeltaRelease = null;
        for (Component aComponent : aCollection) {
            boolean isNew = false;
            Component aOldComponent = oldRelease.components.get(aComponent.getName());
            if (aOldComponent == null) {
                isNew = true;
            } else if (aOldComponent.getCodeBuild() != aComponent.getCodeBuild()) {
                isNew = true;
            } else if (aOldComponent.getSubPath().compareTo(aComponent.getSubPath()) != 0) {
                isNew = true;
            }
            if (!isNew) continue;
            aNovelties.put(aComponent.getName(), aComponent);
            if (aDeltaRelease != null) continue;
            aDeltaRelease = new Release();
            aDeltaRelease.components = aNovelties;
        }
        return aDeltaRelease;
    }

    public boolean prepare() {
        boolean aSuccess = true;
        Collection<Component> aCollection = this.components.values();
        String temp = String.valueOf(this.locationManager.getLocal().getPath()) + "/" + tempPath;
        File aDirTemp = new File(temp);
        aDirTemp.mkdir();
        for (Component aComponent : aCollection) {
            aComponent.setTemp(temp);
            if (aComponent.prepare()) continue;
            aSuccess = false;
            break;
        }
        if (!aSuccess) {
            this.rollback();
        }
        return aSuccess;
    }

    public boolean install() {
        boolean aSuccess = true;
        Collection<Component> aCollection = this.components.values();
        for (Component aComponent : aCollection) {
            if (aComponent.install()) continue;
            aSuccess = false;
            break;
        }
        this.updateDefinition();
        this.cleanPreparation();
        return aSuccess;
    }

    private void cleanPreparation() {
        File aFile = new File(String.valueOf(this.locationManager.getLocal().getPath()) + "/" + tempPath);
        aFile.delete();
    }

    private void updateDefinition() {
        byte[] buffer = new byte[16384];
        Location aRemote = this.locationManager.getRemote();
        Location aLocal = this.locationManager.getLocal();
        InputStream aIn = aRemote.getInputStream(this.definitionName);
        if (aIn == null) {
            return;
        }
        File aFile = new File(String.valueOf(aLocal.getPath()) + "/" + this.definitionName);
        try {
            int bytesRead;
            FileOutputStream aOut = new FileOutputStream(aFile);
            while ((bytesRead = aIn.read(buffer)) != -1) {
                ((OutputStream)aOut).write(buffer, 0, bytesRead);
            }
            aIn.close();
            ((OutputStream)aOut).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean rollback() {
        return true;
    }

    public boolean updateRemote() {
        return this.update(this.locationManager.getRemote());
    }

    public boolean updateLocal() {
        return this.update(this.locationManager.getLocal());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean update(Location aLocation) {
        InputStream aIn;
        if (this.components.size() > 0) {
            this.components.clear();
        }
        if ((aIn = aLocation.getInputStream(this.definitionName)) == null) {
            return false;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(aIn));
        Component aComponent = null;
        try {
            String current;
            while ((current = in.readLine()) != null) {
                if (current.isEmpty()) return false;
                aComponent = Component.build(current);
                this.addComponent(aComponent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            aIn.close();
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean createDefinition() {
        Location aLocal = this.locationManager.getLocal();
        String aDefinition = "";
        Path dir = Paths.get(aLocal.getPath(), new String[0]);
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                for (Path path : stream) {
                    File aFile = path.toFile();
                    String aPath = path.getFileName().toString();
                    if (aPath.compareTo(this.definitionName) == 0) continue;
                    aDefinition = String.valueOf(aDefinition) + aPath + ";" + aFile.lastModified() + ";" + "NO SUB PATH!" + String.format("%n", new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            System.err.println(x);
        }
        OutputStream aOut = aLocal.getOutputStream(this.definitionName);
        if (aOut == null) {
            return false;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(aOut));
        try {
            try {
                out.write(aDefinition);
            }
            catch (IOException ex) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public String toString() {
        String aString = "";
        Collection<Component> aCollection = this.components.values();
        for (Component aComponent : aCollection) {
            aString = String.valueOf(aString) + aComponent.toString() + "\n";
        }
        return aString;
    }

    public void setLocationManager(LocationManager aManager) {
        this.locationManager = aManager;
    }

    public static void main(String[] args) {
        LocationDirectory aLocation = new LocationDirectory();
        aLocation.setPath("C:\\Users\\LocalAdmin\\Documents\\Scanned Documents");
        LocationManager aManager = new LocationManager();
        aManager.setLocal(aLocation);
        Release aRelease = new Release();
        aRelease.setDefinitionName("Version.def");
        aRelease.setLocationManager(aManager);
        aRelease.createDefinition();
        aRelease.update(aLocation);
        System.out.println(aRelease.toString());
    }
}

