float lerp(in float t,in float a,in float b) {
  float g=(a + t*(b - a));
 return g; 
}

float fade(float t) {
  return t * t * t * (t * (t * 6 - 15) + 10); 
}

highp float randp(vec3 co)
{
    highp float a = 12.9898;
    highp float b = 78.233;
    highp float d= 88.3535;
    highp float c = 43758.5453;
    highp float dt= dot(co ,vec3(a,b,d));
    highp float sn= mod(dt,3.14);
    return fract(sin(sn) * c);
}

float noiseA(vec3 co){
  float x=co.x;
  float y=co.y;
  float z=co.z;
  
  float X=floor(x);
  float Y=floor(y);
  float Z=floor(z);

  float dx1=fract(x);
  float dy1=fract(y);
  float dz1=fract(z);
  
  float dx=fade(dx1);
  float dy=fade(dy1);
  float dz=fade(dz1);
  
  float lz1=lerp(dz,randp(vec3(X,Y,Z)),randp(vec3(X,Y,Z+1)));
  float lz2=lerp(dz,randp(vec3(X,Y+1,Z)),randp(vec3(X,Y+1,Z+1)));
  
  float lz3=lerp(dz,randp(vec3(X+1,Y,Z)),randp(vec3(X+1,Y,Z+1)));
  float lz4=lerp(dz,randp(vec3(X+1,Y+1,Z)),randp(vec3(X+1,Y+1,Z+1)));
  
  float ly1=lerp(dy,lz1,lz2);
  float ly2=lerp(dy,lz3,lz4);

  return lerp(dx,ly1,ly2);
}

vec4 mixColor(float x){
  vec4 c=mix(color1,color2,x);
  
  return c;
}

float turbulence(vec3 p,int grid){
  vec3 a=p;
  a.x;

  float aNoise=0;
  float ptow=1;
  
  for(int i=0;i<detail;i++){
    a=p*ptow;
    ptow/=2;
    aNoise+=abs(noiseA(a))*ptow;
    }
    
  return aNoise;
}

vec4 marbleColor(float x){
  vec4 c;
  c.w=1;
  x=sqrt(x+1.0)*0.7071;

  x=clamp(x,0,1);
  c=mix(color1,color2,x);
  
  return c;
}

vec4 marble(vec3 p){
  float y;
  
  y=sqrt(p.x*p.x)+1.0*turbulence(p,1);
  y=sin(2*y*3.14159);
  
  return marbleColor(y);
}

vec4 marbleWoody(vec3 p){
  float y;
  
  y=sqrt(p.y*p.y+p.z*p.z)+4.0*turbulence(p,detail);
  y=sin(8*y*3.14159);
  
  return marbleColor(y);
}

float inLeaf(vec3 aLeafPos){
  vec3 aPos=aLeafPos;
  float aY=aPos.y;
  aPos.y=0;
  float aN=noiseA(aPos*50.0);
  float aTrue=1-smoothstep(aN,aN+0.1,aY);
  
  return aTrue;
}

