#version 150

// base palette
const vec4 color1=vec4(0.2,0.05,0,0.5);
const vec4 color2=vec4(0.4,0.2,0,1.0);

in vec2 UV;

#include "ShaderFInterface.glsl"
#include "ShaderFFunctions.glsl"

void main(void) {
  float fogin=clamp(fog,0,1);
  vec2 aUVfixed=UV;
  aUVfixed.y=1-aUVfixed.y;
    
  vec4 aTextureColor;
  aTextureColor=texture(textureSampler,aUVfixed);

  vec4 aColor;
  aColor=clamp((mix(fogcolor,I*aTextureColor,fogin)),0,1);

  out_Color =aColor;
}	
