/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.idea;

import com.xuarig.idea.InnoParticle;
import com.xuarig.tool.Identifiable;
import com.xuarig.tool.Observable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class InnoConcept
extends Observable
implements Serializable,
Identifiable {
    private InnoConcept theWhole = null;
    private Map<Integer, InnoConcept> theComponents = new HashMap<Integer, InnoConcept>();
    private List<InnoConcept> theFriends = new ArrayList<InnoConcept>();
    private InnoParticle theParticle = new InnoParticle(0.0, 1.0);
    private String theName;
    private String theDescription;
    private int theUniqueId = 0;
    private int theState = 0;
    public static final int NEUTRAL = 0;
    public static final int PLANNED = 1;
    public static final int INPROGRESS_0 = 2;
    public static final int INPROGRESS_25 = 3;
    public static final int INPROGRESS_50 = 4;
    public static final int INPROGRESS_75 = 5;
    public static final int INPROGRESS_100 = 6;
    public static final int IDLED = 7;
    public static final int SINEDIE = 8;
    public static final int CLOSED = 9;
    public static final int CANCELED = 10;
    public static final int WARNING = 11;
    public static final int CRITICAL = 12;

    @Override
    public void setId(int aUniqueId) {
        this.theUniqueId = aUniqueId;
    }

    @Override
    public int getId() {
        return this.theUniqueId;
    }

    public InnoParticle getParticle() {
        return this.theParticle;
    }

    public void setName(String aName) {
        this.theName = aName;
    }

    public String getName() {
        return this.theName;
    }

    public void setDescription(String aDescription) {
        this.theDescription = aDescription;
    }

    public String getDescription() {
        return this.theDescription;
    }

    protected InnoConcept() {
        this.theParticle.setPosition(20.0, 50.0, 20.0);
    }

    public void setWhole(InnoConcept aConcept) {
        this.theWhole = aConcept;
    }

    public InnoConcept getWhole() {
        return this.theWhole;
    }

    public void connectTo(InnoConcept aConcept) {
        if (!this.isConnected(aConcept)) {
            this.theFriends.add(aConcept);
            aConcept.connectTo(this);
        }
    }

    public void separateFrom(InnoConcept aConcept) {
        if (aConcept == null) {
            for (InnoConcept aFriendConcept : this.theFriends) {
                aFriendConcept.theFriends.remove(this);
                this.theFriends.remove(aFriendConcept);
            }
        } else if (this.isConnected(aConcept)) {
            this.theFriends.remove(aConcept);
            aConcept.separateFrom(this);
        }
    }

    public boolean isConnected(InnoConcept aFriend) {
        return this.theFriends.contains(aFriend);
    }

    public void addComponent(InnoConcept aConcept) {
        if (aConcept.getWhole() == this) {
            if (this.theComponents.get(aConcept) == null) {
                System.out.println("Error: " + this.getName() + " - Should include concept :" + aConcept.getName());
            }
            return;
        }
        if (aConcept.getWhole() != null) {
            InnoConcept aWhole = aConcept.getWhole();
            aWhole.removeComponent(aConcept);
            aWhole.setChanged(Observable.Change.CORECHANGED, "LostComponent");
            aWhole.notifyObservers();
        }
        this.theComponents.put(aConcept.getId(), aConcept);
        aConcept.setWhole(this);
    }

    public List<InnoConcept> getComponents() {
        ArrayList<InnoConcept> aListOfConcept = new ArrayList<InnoConcept>();
        Set<Integer> aSet = this.theComponents.keySet();
        for (Integer aKey : aSet) {
            InnoConcept aConcept = this.theComponents.get(aKey);
            aListOfConcept.add(aConcept);
            System.out.println("Component in Concept: " + aConcept.getId() + " - " + aConcept.getName());
        }
        return aListOfConcept;
    }

    public List<InnoConcept> getFriends() {
        return this.theFriends;
    }

    public void removeComponent(InnoConcept aConcept) {
        if (aConcept.getWhole() == this) {
            this.theComponents.remove(aConcept.getId());
            aConcept.setWhole(null);
        }
    }

    public boolean isContainedIn(InnoConcept aComponent) {
        return this.theComponents.get(aComponent) != null;
    }

    public int getState() {
        return this.theState;
    }

    public void setState(int aState) {
        this.theState = aState;
    }

    public void dump() {
        System.out.println("Concept / Name: " + this.getName());
        System.out.println("Id: " + this.getId());
        System.out.println("Parent Concept : " + this.getWhole().getName());
        System.out.println("+ is Connected to :");
        for (InnoConcept aConcept : this.theFriends) {
            System.out.println("\t- " + aConcept.getId() + " / " + aConcept.getName());
        }
        System.out.println("+ contains :");
        Set<Integer> aSetOfLabel = this.theComponents.keySet();
        for (Integer aId : aSetOfLabel) {
            System.out.println("\t- " + aId + " / " + this.theComponents.get(aId).getName());
        }
    }
}

