/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideadataaccess;

import com.xuarig.ideadataaccess.DAOFactoryFile;
import com.xuarig.ideadataaccess.DAOFactorySQL;
import com.xuarig.ideadataaccess.DAOInnoConcept;
import com.xuarig.ideadataaccess.DAOInnoParticle;

public class DAOFactory {
    public static final int NOPERSISTENCE = 0;
    public static final int SQL = 1;
    public static final int FILE = 2;
    public static final int PHPENCAPSULATION = 3;
    private static DAOFactory theInstance = null;
    protected DAOInnoParticle theDAOInnoParticle = null;
    protected DAOInnoConcept theDAOInnoConcept = null;
    private static int thePersistenceMode = 0;
    private String thePath;
    private String theUserName;
    private String thePassword;
    private String theSetName;

    protected DAOFactory() {
    }

    public void endWork() {
    }

    public boolean startWork() {
        return false;
    }

    public boolean align() {
        return false;
    }

    public static DAOFactory getInstance() {
        if (theInstance == null) {
            DAOFactory.adaptPersistence();
        }
        return theInstance;
    }

    public DAOInnoParticle getDAOInnoParticle() {
        return this.theDAOInnoParticle;
    }

    public DAOInnoConcept getDAOInnoConcept() {
        return this.theDAOInnoConcept;
    }

    public static void setPersistence(int aPersistenceMode) {
        thePersistenceMode = aPersistenceMode;
    }

    private static void adaptPersistence() {
        switch (thePersistenceMode) {
            case 1: {
                theInstance = new DAOFactorySQL();
                break;
            }
            case 2: {
                theInstance = new DAOFactoryFile();
                break;
            }
            case 3: {
                theInstance = null;
                break;
            }
            default: {
                theInstance = null;
            }
        }
    }

    public void setPath(String aPath) {
        this.thePath = aPath;
    }

    public String getPath() {
        return this.thePath;
    }

    public void setUserName(String aUserName) {
        this.theUserName = aUserName;
    }

    public String getUserName() {
        return this.theUserName;
    }

    public void setPassword(String aPassword) {
        this.thePassword = aPassword;
    }

    public String getPassword() {
        return this.thePassword;
    }

    public void setSetName(String aSetName) {
        this.theSetName = aSetName;
    }

    public String getSetName() {
        return this.theSetName;
    }
}

