/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideadataaccess;

import com.xuarig.idea.InnoDomain;
import com.xuarig.ideadataaccess.DAOFactory;
import com.xuarig.ideadataaccess.DAOInnoConcept;
import com.xuarig.ideadataaccess.DAOInnoConceptFile;
import com.xuarig.ideadataaccess.DAOInnoParticle;
import com.xuarig.ideadataaccess.DAOInnoParticleFile;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DAOFactoryFile
extends DAOFactory {
    protected DAOFactoryFile() {
    }

    @Override
    public boolean startWork() {
        return this.align();
    }

    @Override
    public void endWork() {
        this.align();
    }

    @Override
    public DAOInnoParticle getDAOInnoParticle() {
        if (this.theDAOInnoParticle == null) {
            this.theDAOInnoParticle = new DAOInnoParticleFile();
        }
        return this.theDAOInnoParticle;
    }

    @Override
    public DAOInnoConcept getDAOInnoConcept() {
        if (this.theDAOInnoConcept == null) {
            this.theDAOInnoConcept = new DAOInnoConceptFile();
        }
        return this.theDAOInnoConcept;
    }

    @Override
    public boolean align() {
        DAOInnoConceptFile aDAOInnoConcept = (DAOInnoConceptFile)this.getDAOInnoConcept();
        DAOInnoParticleFile aDAOInnoParticle = (DAOInnoParticleFile)this.getDAOInnoParticle();
        if (aDAOInnoConcept.getRootDomain() == null) {
            return this.retrieve();
        }
        if (aDAOInnoConcept.isAlignmentNeeded() || aDAOInnoParticle.isAlignmentNeeded()) {
            return this.flush();
        }
        return true;
    }

    private boolean retrieve() {
        DAOInnoConcept aDAOInnoConcept = this.getDAOInnoConcept();
        InnoDomain aRootDomain = null;
        ObjectInputStream aFlow = null;
        try {
            aFlow = new ObjectInputStream(new FileInputStream(this.getSetName()));
            aRootDomain = (InnoDomain)aFlow.readObject();
            ((DAOInnoConceptFile)aDAOInnoConcept).setRootDomain(aRootDomain);
            aFlow.close();
        }
        catch (FileNotFoundException e) {
            aRootDomain = new InnoDomain();
            aRootDomain.setId(0);
            ((DAOInnoConceptFile)aDAOInnoConcept).setRootDomain(aRootDomain);
        }
        catch (EOFException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            try {
                if (aFlow != null) {
                    aFlow.close();
                }
            }
            catch (IOException aExecption) {
                return false;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean flush() {
        DAOInnoConcept aDAOInnoConcept = this.getDAOInnoConcept();
        try {
            ObjectOutputStream aFlow = new ObjectOutputStream(new FileOutputStream(this.getSetName()));
            aFlow.writeObject(aDAOInnoConcept.getRootDomain());
            aFlow.close();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

