/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideadataaccess;

import com.xuarig.ideadataaccess.DAOFactory;
import com.xuarig.ideadataaccess.DAOInnoConcept;
import com.xuarig.ideadataaccess.DAOInnoConceptSQL;
import com.xuarig.ideadataaccess.DAOInnoParticle;
import com.xuarig.ideadataaccess.DAOInnoParticleSQL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DAOFactorySQL
extends DAOFactory {
    private Connection theConnection = null;

    protected DAOFactorySQL() {
    }

    private boolean initiateDriver() {
        boolean hasDriver = false;
        try {
            Class.forName("com.mysql.jdbc.Driver");
            System.out.println("Driver passed");
            hasDriver = true;
        }
        catch (ClassNotFoundException aException) {
            System.out.println("Driver not found !");
        }
        return hasDriver;
    }

    @Override
    public boolean startWork() {
        boolean isWorking = false;
        if (this.theConnection == null && this.initiateDriver()) {
            try {
                this.theConnection = DriverManager.getConnection("jdbc:mysql:" + this.getPath() + "/" + this.getSetName(), this.getUserName(), this.getPassword());
                System.out.println("Connection passed");
                isWorking = true;
            }
            catch (SQLException aException) {
                this.theConnection = null;
                System.out.println("No connection is possible to database");
            }
        }
        return isWorking;
    }

    @Override
    public void endWork() {
        try {
            this.theConnection.close();
            System.out.println("Database connection ended");
        }
        catch (SQLException aException) {
            System.out.println("Cannot close database connection");
        }
    }

    protected void setConnection(Connection aConnection) {
        this.theConnection = aConnection;
    }

    protected Connection getConnection() {
        return this.theConnection;
    }

    @Override
    public DAOInnoParticle getDAOInnoParticle() {
        if (this.theDAOInnoParticle == null) {
            this.theDAOInnoParticle = new DAOInnoParticleSQL(this.theConnection);
        }
        return this.theDAOInnoParticle;
    }

    @Override
    public DAOInnoConcept getDAOInnoConcept() {
        if (this.theDAOInnoConcept == null) {
            this.theDAOInnoConcept = new DAOInnoConceptSQL(this.theConnection);
        }
        return this.theDAOInnoConcept;
    }
}

