/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideadataaccess;

import com.xuarig.businessmodel.BusinessCustomerSegment;
import com.xuarig.businessmodel.BusinessModel;
import com.xuarig.businessmodel.BusinessUniqueValueProposition;
import com.xuarig.idea.InnoConcept;
import com.xuarig.idea.InnoDomain;
import com.xuarig.idea.InnoGoal;
import com.xuarig.idea.InnoParticle;
import com.xuarig.idea.InnoProblem;
import com.xuarig.idea.InnoSolution;
import com.xuarig.ideadataaccess.DAOFactory;
import com.xuarig.ideadataaccess.DAOInnoConcept;
import com.xuarig.ideadataaccess.DAOInnoParticle;
import com.xuarig.tool.DAO;
import com.xuarig.tool.SQLTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DAOInnoConceptSQL
extends DAO<InnoConcept>
implements DAOInnoConcept {
    public static final int TYPE_GOAL = 1;
    public static final int TYPE_SOLUTION = 2;
    public static final int TYPE_PROBLEM = 3;
    public static final int TYPE_BUSINESSMODEL = 4;
    public static final int TYPE_CUSTOMERSEGMENT = 5;
    public static final int TYPE_DOMAIN = 6;
    public static final int TYPE_UNIQUEVALUEPROPOSITION = 7;
    private Map<Integer, InnoConcept> theInnoConcepts = new HashMap<Integer, InnoConcept>();

    public DAOInnoConceptSQL(Connection aConnection) {
        super(aConnection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean create(InnoConcept aObject) {
        ResultSet aResultSet;
        Statement aStatement;
        block4: {
            System.out.println("DAOInnoConcept/Create - start");
            if (aObject == null) return false;
            System.out.println("DAOInnoConcept/Create - object exists");
            if (aObject.getId() != 0) return false;
            try {
                System.out.println("DAOInnoConcept/Create - prepare for statement");
                aStatement = this.theConnection.createStatement(1005, 1008);
                System.out.println("DAOInnoConcept/Create - statement done");
                String aSQLString = SQLTool.cleanString(aObject.getName());
                String aSQLQuery = "INSERT INTO concept (Name) VALUES ('" + aSQLString + "')";
                System.out.println("DAOInnoConcept/Create - SQL Query to be run: " + aSQLQuery);
                aStatement.executeUpdate(aSQLQuery);
                System.out.println("DAOInnoConcept/Create - row inserted in concept");
                aResultSet = aStatement.executeQuery("SELECT * FROM concept where idConcept=LAST_INSERT_ID()");
                System.out.println("DAOInnoConcept/Create - new item should be selected");
                if (!aResultSet.first()) return false;
                System.out.println("DAOInnoConcept/Create - new item selected");
                aObject.setId(aResultSet.getInt("idConcept"));
                System.out.println("DAOInnoConcept/Create - id established");
                aResultSet.updateString("Description", aObject.getDescription());
                System.out.println("DAOInnoConcept/Create - Description updated");
                aResultSet.updateInt("TypeOfConcept", this.getConceptType(aObject));
                System.out.println("DAOInnoConcept/Create - Type of concept updated");
                aResultSet.updateInt("idParent", aObject.getWhole().getId());
                System.out.println("DAOInnoConcept/Create - Parent id updated" + aObject.getWhole().getId());
                aResultSet.updateInt("State", aObject.getState());
                System.out.println("DAOInnoConcept/Create - Set default state");
                InnoParticle aInnoParticle = aObject.getParticle();
                DAOFactory aDAOFactory = DAOFactory.getInstance();
                DAOInnoParticle aDAOInnoParticle = aDAOFactory.getDAOInnoParticle();
                System.out.println("DAOInnoConcept/Create - Prepare to add Particle");
                if (aDAOInnoParticle.create(aInnoParticle)) {
                    aResultSet.updateInt("idParticle", aInnoParticle.getId());
                    break block4;
                }
                aStatement.close();
                aResultSet.close();
                return false;
            }
            catch (SQLException aException) {
                System.out.println(aException.toString());
                return false;
            }
        }
        aResultSet.updateRow();
        System.out.println("DAOInnoConcept/Create - data updated");
        aStatement.close();
        aResultSet.close();
        this.cache(aObject);
        return true;
    }

    @Override
    public boolean delete(InnoConcept aConcept) {
        try {
            System.out.println("DAOInnoConcept/delete - Prepare particule deletion");
            DAOInnoParticle aDAOInnoParticle = DAOFactory.getInstance().getDAOInnoParticle();
            aDAOInnoParticle.delete(aConcept.getParticle());
            System.out.println("DAOInnoConcept/delete - particule deleted");
            System.out.println("DAOInnoConcept/delete - Prepare friendships deletion");
            this.deleteFriendships(aConcept);
            System.out.println("DAOInnoConcept/delete - Prepare friendships deleted");
            System.out.println("DAOInnoConcept/delete - Prepare component deletion");
            System.out.println("DAOInnoConcept/delete - Prepare component NOT deleted");
            PreparedStatement aStatement = this.theConnection.prepareStatement("DELETE FROM concept WHERE idConcept = ?");
            aStatement.setInt(1, aConcept.getId());
            if (aStatement.executeUpdate() == 0) {
                System.out.println("DAOInnoConcept/delete - No Concept deleted");
            } else {
                System.out.println("DAOInnoConcept/delete - Concept deleted");
                this.removeCache(aConcept.getId());
            }
            InnoConcept aMainConcept = aConcept.getWhole();
            if (aMainConcept != null) {
                aMainConcept.removeComponent(aConcept);
            }
            aStatement.close();
        }
        catch (SQLException aException) {
            System.out.println(aException.toString());
            return false;
        }
        return true;
    }

    public boolean deleteFriendships(InnoConcept aConcept) {
        return this.deleteFriendships(aConcept.getId());
    }

    public boolean deleteFriendships(int aId) {
        try {
            System.out.println("DAOInnoConcept/deleteFriendships - Prepare statement for deletion");
            PreparedStatement aStatement = this.theConnection.prepareStatement("DELETE FROM concept_concept_friend WHERE idConceptA = ?");
            aStatement.setInt(1, aId);
            aStatement.executeUpdate();
            aStatement = this.theConnection.prepareStatement("DELETE FROM concept_concept_friend WHERE idConceptB = ?");
            aStatement.setInt(1, aId);
            aStatement.executeUpdate();
            System.out.println("DAOInnoConcept/deleteFriendships - Concepts separated");
            aStatement.close();
        }
        catch (SQLException aException) {
            System.out.println(aException.toString());
            return false;
        }
        return true;
    }

    public boolean deleteComponents(InnoDomain aDomain) {
        try {
            ResultSet aResultSet;
            boolean isSearchable = true;
            System.out.println("DAOInnoConcept/deleteComponents - Prepare statement for deletion");
            Statement aStatement = this.theConnection.createStatement(1004, 1007);
            System.out.println("DAOInnoConcept/deleteComponents - statement done : " + (aStatement != null));
            System.out.println("DAOInnoConcept/deleteComponents - start");
            do {
                System.out.println("DAOInnoConcept/deleteComponents - before Query : All components");
                aResultSet = aStatement.executeQuery("SELECT * FROM concept WHERE idParent=" + aDomain.getId());
                System.out.println("DAOInnoConcept/deleteComponents - component selection done in base");
                if (aResultSet.first()) {
                    int aIdComponent = aResultSet.getInt("idConcept");
                    continue;
                }
                isSearchable = false;
            } while (isSearchable);
            aStatement.close();
            aResultSet.close();
            System.out.println("DAOInnoConcept/deleteComponents - friends connected");
        }
        catch (SQLException aException) {
            System.out.println(aException.toString());
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean update(InnoConcept aObject) {
        System.out.println("DAOInnoConcept/Update - start");
        if (aObject == null) return false;
        System.out.println("DAOInnoConcept/Update - object exists");
        if (aObject.getId() == 0) return false;
        try {
            System.out.println("DAOInnoConcept/Update - id is not null");
            PreparedStatement aStatement = this.theConnection.prepareStatement("UPDATE concept SET Name = ?, Description = ?, State = ? WHERE idConcept = ?");
            aStatement.setString(1, aObject.getName());
            aStatement.setString(2, aObject.getDescription());
            aStatement.setInt(3, aObject.getState());
            aStatement.setInt(4, aObject.getId());
            aStatement.executeUpdate();
            System.out.println("DAOInnoConcept/Update - row updated in concept");
            aStatement.close();
            return true;
        }
        catch (SQLException aException) {
            System.out.println(aException.toString());
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean createFriendship(InnoConcept aConceptA, InnoConcept aConceptB) {
        ResultSet aResultSet;
        Statement aStatement;
        block5: {
            block4: {
                System.out.println("DAOInnoConcept/update friends - start");
                if (aConceptA == null || aConceptB == null) return false;
                System.out.println("DAOInnoConcept/create friendship - object exists");
                if (aConceptA.getId() == 0 || aConceptB.getId() == 0) return false;
                try {
                    System.out.println("DAOInnoConcept/create friendship - prepare for statement");
                    aStatement = this.theConnection.createStatement(1005, 1008);
                    System.out.println("DAOInnoConcept/create friendship - statement done");
                    aResultSet = aStatement.executeQuery("SELECT * FROM concept_concept_friend WHERE idConceptA=" + aConceptA.getId() + " AND idConceptB=" + aConceptB.getId());
                    System.out.println("DAOInnoConcept/create friendship - friend relationship AB selection done in base");
                    if (!aResultSet.first()) break block4;
                    System.out.println("DAOInnoConcept/create friendship - friendship already in dase");
                    return true;
                }
                catch (SQLException aException) {
                    System.out.println(aException.toString());
                    return false;
                }
            }
            aResultSet = aStatement.executeQuery("SELECT * FROM concept_concept_friend WHERE idConceptA=" + aConceptB.getId() + " AND idConceptB=" + aConceptA.getId());
            System.out.println("DAOInnoConcept/create friendship - friend relationship BA selection done in base");
            if (!aResultSet.first()) break block5;
            System.out.println("DAOInnoConcept/create friendship - friendship already in dase");
            return true;
        }
        aStatement.executeUpdate("INSERT INTO concept_concept_friend (idConceptA, idConceptB) VALUES (" + aConceptA.getId() + "," + aConceptB.getId() + ")");
        aConceptA.connectTo(aConceptB);
        System.out.println("DAOInnoConcept/create friendship - friendship created in base");
        aStatement.close();
        aResultSet.close();
        return true;
    }

    @Override
    public boolean separate(InnoConcept aConceptA, InnoConcept aConceptB) {
        PreparedStatement aStatement;
        block3: {
            try {
                System.out.println("DAOInnoConcept/separate - Prepare statement for deletion");
                aStatement = this.theConnection.prepareStatement("DELETE FROM concept_concept_friend WHERE idConceptA = ? AND idConceptB = ? ");
                aStatement.setInt(1, aConceptA.getId());
                aStatement.setInt(2, aConceptB.getId());
                if (aStatement.executeUpdate() != 0) break block3;
                aStatement = this.theConnection.prepareStatement("DELETE FROM concept_concept_friend WHERE idConceptA = ? AND idConceptB = ? ");
                aStatement.setInt(1, aConceptB.getId());
                aStatement.setInt(2, aConceptA.getId());
                if (aStatement.executeUpdate() != 0) break block3;
                return false;
            }
            catch (SQLException aException) {
                System.out.println(aException.toString());
                return false;
            }
        }
        aConceptA.separateFrom(aConceptB);
        System.out.println("DAOInnoConcept/separate - Concepts separated");
        aStatement.close();
        return true;
    }

    public boolean findFriends(InnoConcept aConcept) {
        if (aConcept == null) {
            System.out.println("DAOInnoConcept/find friends - concept is not existing");
            return false;
        }
        try {
            System.out.println("DAOInnoConcept/find friends - prepare for statement");
            Statement aStatement = this.theConnection.createStatement(1004, 1007);
            System.out.println("DAOInnoConcept/find friends - statement done : " + (aStatement != null));
            System.out.println("DAOInnoConcept/find friends - start");
            System.out.println("DAOInnoConcept/find friends - before Query : Concept friend");
            ResultSet aResultSet = aStatement.executeQuery("SELECT * FROM concept_concept_friend WHERE idConceptA=" + aConcept.getId() + " OR idConceptB=" + aConcept.getId());
            System.out.println("DAOInnoConcept/find friends - friend relationship selection done in base");
            while (aResultSet.next()) {
                int aIdA = aResultSet.getInt("idConceptA");
                int aIdB = aResultSet.getInt("idConceptB");
                System.out.println("DAOInnoConcept/find friends - IdA:" + aIdA + " / IdB: " + aIdB);
                InnoConcept aConceptA = this.find(aIdA);
                InnoConcept aConceptB = this.find(aIdB);
                aConceptA.connectTo(aConceptB);
            }
            aStatement.close();
            aResultSet.close();
            System.out.println("DAOInnoConcept/find friends - friends connected");
        }
        catch (SQLException aException) {
            System.out.println(aException.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean findComponents(InnoDomain aDomain) {
        if (aDomain == null) {
            System.out.println("DAOInnoConcept/find components - domain is not existing");
            return false;
        }
        try {
            System.out.println("DAOInnoConcept/find components - prepare for statement");
            Statement aStatement = this.theConnection.createStatement(1004, 1007);
            System.out.println("DAOInnoConcept/find components - statement done : " + (aStatement != null));
            System.out.println("DAOInnoConcept/find components - start");
            System.out.println("DAOInnoConcept/find components - before Query : All friends");
            ResultSet aResultSet = aStatement.executeQuery("SELECT * FROM concept WHERE idParent=" + aDomain.getId());
            System.out.println("DAOInnoConcept/find components - component selection done in base");
            while (aResultSet.next()) {
                int aIdComponent = aResultSet.getInt("idConcept");
                System.out.println("DAOInnoConcept/find components - IdComponnt:" + aIdComponent);
                InnoConcept aConceptComponent = this.find(aIdComponent);
                aDomain.addComponent(aConceptComponent);
            }
            aStatement.close();
            aResultSet.close();
            aDomain.setVisible();
            System.out.println("DAOInnoConcept/find components - components added");
        }
        catch (SQLException aException) {
            System.out.println(aException.toString());
            return false;
        }
        return true;
    }

    @Override
    public InnoConcept find(int aId) {
        InnoConcept aConcept = this.findCache(aId);
        if (aConcept != null) {
            System.out.println("DAOInnoConcept/find with id - Concept in Cache");
            return aConcept;
        }
        try {
            System.out.println("DAOInnoConcept/find with id - prepare for statement");
            Statement aStatement = this.theConnection.createStatement(1004, 1007);
            System.out.println("DAOInnoConcept/find with id - statement done : " + (aStatement != null));
            System.out.println("DAOInnoConcept/find with id - before Query : Concept with id");
            ResultSet aResultSet = aStatement.executeQuery("SELECT * FROM concept WHERE idConcept=" + aId);
            System.out.println("DAOInnoConcept/find with id - component selection done in base");
            if (aResultSet.first()) {
                int aIdConcept;
                DAOInnoParticle aDAOInnoParticle = DAOFactory.getInstance().getDAOInnoParticle();
                int aTypeOfConcept = aResultSet.getInt("TypeOfConcept");
                aConcept = this.instantiateInnoConcept(aTypeOfConcept, aIdConcept = aResultSet.getInt("idConcept"));
                if (aConcept != null) {
                    String aName = aResultSet.getString("Name");
                    aConcept.setName(aName);
                    String aDescription = aResultSet.getString("Description");
                    aConcept.setDescription(aDescription);
                    int aState = aResultSet.getInt("State");
                    aConcept.setState(aState);
                    int aIdParticle = aResultSet.getInt("idParticle");
                    aConcept.getParticle().setId(aIdParticle);
                    aDAOInnoParticle.find(aConcept.getParticle());
                    System.out.println(" [Concept] " + aName + " - " + aDescription);
                    this.cache(aConcept);
                    this.findFriends(aConcept);
                } else {
                    System.out.println("DAOInnoConcept/find with id - problem with concept creation: " + aIdConcept + " of Type " + aTypeOfConcept);
                }
            } else {
                System.out.println("DAOInnoConcept/find with id - concept not found creation: " + aId);
            }
            aStatement.close();
            aResultSet.close();
            System.out.println("DAOInnoConcept/find with id - friends connected");
        }
        catch (SQLException aException) {
            System.out.println(aException.toString());
            return null;
        }
        return aConcept;
    }

    @Override
    public InnoDomain getRootDomain() {
        InnoDomain aRootDomain = (InnoDomain)this.findCache(0);
        if (aRootDomain == null) {
            aRootDomain = (InnoDomain)this.instantiateInnoConcept(6, 0);
            aRootDomain.setName("Root");
        }
        if (!aRootDomain.isVisible()) {
            this.findComponents(aRootDomain);
        }
        return aRootDomain;
    }

    private InnoConcept instantiateInnoConcept(int aTypeOfConcept, int aIdConcept) {
        InnoConcept aConcept = null;
        switch (aTypeOfConcept) {
            case 1: {
                aConcept = new InnoGoal();
                break;
            }
            case 2: {
                aConcept = new InnoSolution();
                break;
            }
            case 3: {
                aConcept = new InnoProblem();
                break;
            }
            case 4: {
                aConcept = new BusinessModel();
                break;
            }
            case 5: {
                aConcept = new BusinessCustomerSegment();
                break;
            }
            case 6: {
                aConcept = new InnoDomain();
                break;
            }
            case 7: {
                aConcept = new BusinessUniqueValueProposition();
            }
        }
        if (aConcept != null) {
            aConcept.setId(aIdConcept);
        }
        return aConcept;
    }

    private int getConceptType(InnoConcept aConcept) {
        if (aConcept.getClass() == InnoGoal.class) {
            return 1;
        }
        if (aConcept.getClass() == InnoSolution.class) {
            return 2;
        }
        if (aConcept.getClass() == InnoProblem.class) {
            return 3;
        }
        if (aConcept.getClass() == BusinessModel.class) {
            return 4;
        }
        if (aConcept.getClass() == BusinessCustomerSegment.class) {
            return 5;
        }
        if (aConcept.getClass() == InnoDomain.class) {
            return 6;
        }
        if (aConcept.getClass() == BusinessUniqueValueProposition.class) {
            return 7;
        }
        return 0;
    }

    protected InnoConcept findCache(int aId) {
        return this.theInnoConcepts.get(aId);
    }

    protected InnoConcept removeCache(int aId) {
        return this.theInnoConcepts.remove(aId);
    }

    protected void cache(InnoConcept aInnoConcept) {
        this.theInnoConcepts.put(aInnoConcept.getId(), aInnoConcept);
    }
}

