/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideadataaccess;

import com.xuarig.tool.Identifiable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class DAOObjectFile<T extends Identifiable> {
    private Map<Integer, T> theObjects = new HashMap<Integer, T>();
    private boolean isAlignmentNeeded = false;

    public boolean create(T aObject) {
        int aUID = 0;
        if (aObject == null) {
            return false;
        }
        if (aObject.getId() != 0) {
            return false;
        }
        aUID = this.generateUniqueID();
        aObject.setId(aUID);
        this.theObjects.put(aUID, aObject);
        this.needAlignment();
        return true;
    }

    private int generateUniqueID() {
        int aUID;
        Random randomGenerator = new Random();
        Identifiable aObject = null;
        while ((aObject = (Identifiable)this.theObjects.get(aUID = randomGenerator.nextInt(Integer.MAX_VALUE))) != null) {
        }
        return aUID;
    }

    public boolean delete(T aObject) {
        if (aObject == null) {
            return false;
        }
        this.needAlignment();
        return this.theObjects.remove(aObject.getId()) != null;
    }

    public boolean update(T aObject) {
        if (aObject == null) {
            return false;
        }
        this.needAlignment();
        return true;
    }

    public T find(int aId) {
        return (T)((Identifiable)this.theObjects.get(aId));
    }

    public boolean find(T aObject) {
        if (aObject == null) {
            return false;
        }
        this.needAlignment();
        return this.find(aObject.getId()) != null;
    }

    public boolean cache(T aObject) {
        if (aObject == null) {
            return false;
        }
        if (this.theObjects.get(aObject.getId()) != null) {
            return false;
        }
        this.theObjects.put(aObject.getId(), aObject);
        return true;
    }

    public boolean deCache(T aObject) {
        if (aObject == null) {
            return false;
        }
        if (this.theObjects.get(aObject.getId()) == null) {
            return false;
        }
        this.theObjects.remove(aObject.getId());
        return true;
    }

    public boolean isAlignmentNeeded() {
        return this.isAlignmentNeeded;
    }

    public void needAlignment() {
        this.isAlignmentNeeded = true;
    }

    public void keepAligned() {
        this.isAlignmentNeeded = false;
    }
}

