/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideaview;

import com.xuarig.bmview.FrameBMCanevas;
import com.xuarig.businessmodel.BusinessCustomerSegment;
import com.xuarig.businessmodel.BusinessModel;
import com.xuarig.businessmodel.BusinessUniqueValueProposition;
import com.xuarig.idea.InnoConcept;
import com.xuarig.idea.InnoDomain;
import com.xuarig.idea.InnoGoal;
import com.xuarig.idea.InnoProblem;
import com.xuarig.idea.InnoSolution;
import com.xuarig.ideadataaccess.DAOFactory;
import com.xuarig.ideadataaccess.DAOInnoConcept;
import com.xuarig.ideadataaccess.DAOInnoParticle;
import com.xuarig.ideaview.FrameIdea;
import com.xuarig.ideaview.RendererConcept;
import com.xuarig.tool.Observable;
import com.xuarig.tool.Renderer;
import com.xuarig.tool.RendererConnector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ControlConcept {
    public static InnoConcept createConcept(InnoDomain aDomain, String aName, Class aClass) {
        InnoConcept aConcept = null;
        if (aClass == InnoProblem.class) {
            aConcept = new InnoProblem();
        } else if (aClass == InnoGoal.class) {
            aConcept = new InnoGoal();
        } else if (aClass == InnoSolution.class) {
            aConcept = new InnoSolution();
        } else if (aClass == BusinessModel.class) {
            aConcept = new BusinessModel();
        } else if (aClass == BusinessCustomerSegment.class) {
            aConcept = new BusinessCustomerSegment();
        } else if (aClass == InnoDomain.class) {
            aConcept = new InnoDomain();
        } else if (aClass == BusinessUniqueValueProposition.class) {
            aConcept = new BusinessUniqueValueProposition();
        }
        if (aConcept != null) {
            aConcept.setName(aName);
            DAOInnoConcept aDAO = DAOFactory.getInstance().getDAOInnoConcept();
            aConcept.setWhole(aDomain);
            aDAO.create(aConcept);
            aConcept.setWhole(null);
            aDomain.addComponent(aConcept);
            aDomain.setChanged(Observable.Change.CORECHANGED, "AddComponent");
            aDomain.notifyObservers();
        }
        return aConcept;
    }

    public static boolean separateConcepts(InnoConcept aConceptA, InnoConcept aConceptB) {
        if (aConceptA != null && aConceptB != null) {
            aConceptA.separateFrom(aConceptB);
            DAOInnoConcept aDAO = DAOFactory.getInstance().getDAOInnoConcept();
            aDAO.separate(aConceptA, aConceptB);
            aConceptA.setChanged(Observable.Change.CHANGED, "LostFriend");
            aConceptB.setChanged(Observable.Change.CHANGED, "LostFriend");
            aConceptA.notifyObservers();
            aConceptB.notifyObservers();
            return true;
        }
        return false;
    }

    public static boolean connectConcepts(InnoConcept aConceptA, InnoConcept aConceptB) {
        if (aConceptA != null && aConceptB != null) {
            DAOInnoConcept aDAO = DAOFactory.getInstance().getDAOInnoConcept();
            if (!aDAO.createFriendship(aConceptA, aConceptB)) {
                return false;
            }
            aConceptA.setChanged(Observable.Change.CHANGED, "MadeFriend");
            aConceptB.setChanged(Observable.Change.CHANGED, "MadeFriend");
            aConceptA.notifyObservers();
            aConceptB.notifyObservers();
            return true;
        }
        return false;
    }

    public static boolean createConceptOfType(String aTypeOfConcept, InnoDomain aDomain, String aName, double aX, double aY) {
        Class<?> aClass;
        try {
            aClass = Class.forName(aTypeOfConcept);
        }
        catch (ClassNotFoundException aException) {
            return false;
        }
        InnoConcept aConcept = ControlConcept.createConcept(aDomain, aName, aClass);
        if (aConcept == null) {
            return false;
        }
        ControlConcept.changePosition(aConcept, aX, aY);
        return true;
    }

    public static void changePosition(Renderer aRenderer, double aXPlan, double aYPlan) {
        if (aRenderer.getClass() == RendererConcept.class) {
            InnoConcept aConcept = ((RendererConcept)aRenderer).getConcept();
            ControlConcept.changePosition(aConcept, aXPlan, aYPlan);
        }
    }

    public static void changePosition(InnoConcept aConcept, double aXPlan, double aYPlan) {
        aConcept.getParticle().setPosition(aXPlan, aYPlan, 0.0);
        DAOInnoParticle aDAO = DAOFactory.getInstance().getDAOInnoParticle();
        aDAO.update(aConcept.getParticle());
        aConcept.setChanged(Observable.Change.CORECHANGED, "Position");
        aConcept.notifyObservers();
    }

    public static void showDetail(Renderer aRenderer) {
        if (aRenderer.getClass() == RendererConcept.class) {
            InnoConcept aConcept = ((RendererConcept)aRenderer).getConcept();
            if (aConcept.getClass() == BusinessModel.class) {
                FrameBMCanevas aFrame = new FrameBMCanevas();
                aFrame.setBusinessModel((BusinessModel)aConcept);
            } else if (aConcept.getClass() == InnoDomain.class) {
                InnoDomain aDomain = (InnoDomain)aConcept;
                FrameIdea aFrame = new FrameIdea();
                if (!aDomain.isVisible()) {
                    DAOFactory.getInstance().getDAOInnoConcept().findComponents(aDomain);
                    aDomain.setVisible();
                }
                aFrame.setDomainView(aDomain);
            }
        }
    }

    public static void updateRenderer(RendererConcept aRenderer) {
        ControlConcept.updateConcept(aRenderer.getConcept());
    }

    public static void updateConcept(InnoConcept aConcept) {
        DAOInnoConcept aDAO = DAOFactory.getInstance().getDAOInnoConcept();
        aDAO.update(aConcept);
        aConcept.setChanged(Observable.Change.CORECHANGED, "Name");
        aConcept.notifyObservers();
    }

    public static boolean completeConnnector(RendererConnector aPivotConnector, Renderer aRendererB) {
        Renderer aRendererA = aPivotConnector.getRendererA();
        if (aRendererA.getClass() == RendererConcept.class && aRendererB.getClass() == RendererConcept.class) {
            InnoConcept aConceptA = ((RendererConcept)aRendererA).getConcept();
            InnoConcept aConceptB = ((RendererConcept)aRendererB).getConcept();
            ControlConcept.connectConcepts(aConceptA, aConceptB);
            aPivotConnector.completeRendererB(aRendererB);
            aConceptA.addObserver(aPivotConnector);
            aConceptB.addObserver(aPivotConnector);
            return true;
        }
        return false;
    }

    public static boolean deleteRenderer(Renderer aRenderer) {
        if (aRenderer == null) {
            return false;
        }
        DAOInnoConcept aDAOInnoConcept = DAOFactory.getInstance().getDAOInnoConcept();
        if (aRenderer.getClass() == RendererConnector.class) {
            RendererConnector aRendererConnector = (RendererConnector)aRenderer;
            if (aRendererConnector.getRendererA().getClass() == RendererConcept.class) {
                RendererConcept aRendererConceptA = (RendererConcept)aRendererConnector.getRendererA();
                RendererConcept aRendererConceptB = (RendererConcept)aRendererConnector.getRendererB();
                ControlConcept.separateConcepts(aRendererConceptA.getConcept(), aRendererConceptB.getConcept());
                return true;
            }
        } else if (aRenderer.getClass() == RendererConcept.class) {
            RendererConcept aRendererConcept = (RendererConcept)aRenderer;
            InnoConcept aConcept = aRendererConcept.getConcept();
            aDAOInnoConcept.delete(aConcept);
            aConcept.setChanged(Observable.Change.INDELETION);
            aConcept.notifyObservers();
        }
        return false;
    }

    public static void dump(RendererConcept aRendererConcept) {
        InnoConcept aConcept = aRendererConcept.getConcept();
        aConcept.dump();
    }

    public static List<Renderer> initDomainRenderers(InnoDomain aDomain) {
        ArrayList<Renderer> aListRenderer = new ArrayList<Renderer>();
        HashMap<InnoConcept, RendererConcept> aMapRenderer = new HashMap<InnoConcept, RendererConcept>();
        ArrayList<String> aListCode = new ArrayList<String>();
        List<InnoConcept> aListConcept = aDomain.getComponents();
        System.out.println("ControlConcept - About to Create renderers in Domain");
        for (InnoConcept aConcept : aListConcept) {
            RendererConcept aRenderer = new RendererConcept(aConcept);
            aMapRenderer.put(aConcept, aRenderer);
            aListRenderer.add(aRenderer);
        }
        for (InnoConcept aConcept : aListConcept) {
            List<InnoConcept> aListFriends = aConcept.getFriends();
            for (InnoConcept aFriendConcept : aListFriends) {
                String aCode = ControlConcept.getFriendshipCode(aConcept, aFriendConcept);
                if (aListCode.contains(aCode)) continue;
                RendererConnector aRendererConnector = new RendererConnector((Renderer)aMapRenderer.get(aConcept), (Renderer)aMapRenderer.get(aFriendConcept));
                aConcept.addObserver(aRendererConnector);
                aFriendConcept.addObserver(aRendererConnector);
                aListRenderer.add(aRendererConnector);
                aListCode.add(aCode);
            }
        }
        System.out.println("ControlConcept - Renderers in Domain created");
        return aListRenderer;
    }

    public static String getFriendshipCode(InnoConcept aConceptA, InnoConcept aConceptB) {
        String aCode = null;
        aCode = aConceptA.getId() < aConceptB.getId() ? "[" + aConceptA.getId() + "-" + aConceptB.getId() + "]" : "[" + aConceptB.getId() + "-" + aConceptA.getId() + "]";
        return aCode;
    }
}

