/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideaview;

import com.xuarig.idea.InnoDomain;
import com.xuarig.ideadataaccess.DAOFactory;
import com.xuarig.ideaview.FrameIdea;
import com.xuarig.tool.FormalTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IdeaLauncher {
    public static final String theVersion = "O.12";
    private static final String theMailAddress = "feedback@xuarig.fr";
    private static FrameIdea theFrame;
    private static String[] theDefaultPersistence;

    static {
        theDefaultPersistence = new String[]{"FILE"};
    }

    public static void main(String[] args) {
        if (FormalTool.isStringInIgnoreCase("debugfile", args)) {
            IdeaLauncher.sendOutFile();
        }
        if (FormalTool.isStringInIgnoreCase("FILE", args) || FormalTool.isStringInIgnoreCase("SQL", args) || FormalTool.isStringInIgnoreCase("PHPXML", args)) {
            System.out.println("Requested mode: " + args[0] + " " + args[0].length());
            IdeaLauncher.initiatePersistence(args);
        } else {
            IdeaLauncher.initiatePersistence(theDefaultPersistence);
        }
        DAOFactory aDAOFactory = DAOFactory.getInstance();
        if (aDAOFactory.startWork()) {
            InnoDomain aRootDomain = aDAOFactory.getDAOInnoConcept().getRootDomain();
            theFrame = new FrameIdea();
            theFrame.setDomainView(aRootDomain);
            theFrame.setDefaultCloseOperation(3);
        }
    }

    public static void sendOutFile() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HH_mm_ss");
        Date date = new Date();
        String aName = "log_" + dateFormat.format(date) + ".txt";
        File file = new File(aName);
        try {
            System.out.println("Note that console is redirected to file:" + aName + " in your execution directory, as now.");
            PrintStream printStream = new PrintStream(file);
            System.setOut(printStream);
            System.out.println("Project ideavers - Version:O.12");
            System.out.println("Please direct your bug report or comments to: feedback@xuarig.fr");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean initiatePersistence(String[] aCmdLine) {
        if (FormalTool.isStringInIgnoreCase("SQL", aCmdLine)) {
            System.out.println("SQL mode");
            DAOFactory.setPersistence(1);
            DAOFactory aDAOFactory = DAOFactory.getInstance();
            aDAOFactory.setPath("//localhost:3306");
            aDAOFactory.setSetName("Test");
            aDAOFactory.setUserName("testdev");
            aDAOFactory.setPassword("TchocoNy18&");
        } else {
            if (FormalTool.isStringInIgnoreCase("PHPXML", aCmdLine)) {
                System.out.println("PHPXML client");
                return false;
            }
            if (FormalTool.isStringInIgnoreCase("FILE", aCmdLine)) {
                System.out.println("FILE stand alone version");
                DAOFactory.setPersistence(2);
                DAOFactory aDAOFactory = DAOFactory.getInstance();
                aDAOFactory.setPath("");
                aDAOFactory.setSetName("Test");
                aDAOFactory.setUserName("");
                aDAOFactory.setPassword("");
            } else {
                return false;
            }
        }
        return true;
    }
}

