/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideaview;

import com.xuarig.ideaview.ControlConcept;
import com.xuarig.ideaview.PanelOfConcepts;
import com.xuarig.ideaview.RendererConcept;
import com.xuarig.princetontool.Interval;
import com.xuarig.princetontool.Interval2D;
import com.xuarig.tool.Renderer;
import com.xuarig.tool.RendererConnector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class InteractorPanelOfConcepts {
    private PanelOfConcepts thePanelOfConcepts;
    private Map<String, Renderer> theSelection = new HashMap<String, Renderer>();
    private JPopupMenu theDefaultPopup;
    private List<RendererConnector> theTemporaryConnectors = new ArrayList<RendererConnector>();
    private int theFocusX = 0;
    private int theFocusY = 0;
    private int theStartDragX = 0;
    private int theStartDragY = 0;
    boolean isConnecting = false;
    boolean isDragging = false;

    public void setFocus(int aX, int aY) {
        this.theFocusX = aX;
        this.theFocusY = aY;
    }

    public int getFocusX() {
        return this.theFocusX;
    }

    public int getFocusY() {
        return this.theFocusY;
    }

    public InteractorPanelOfConcepts(PanelOfConcepts aPanelOfConcepts) {
        this.thePanelOfConcepts = aPanelOfConcepts;
        this.createDefaultMenu();
    }

    PanelOfConcepts getPanelOfConcepts() {
        return this.thePanelOfConcepts;
    }

    public boolean addToSelection(Renderer aRenderer) {
        if (this.isConnecting) {
            this.cleanSelectionAll();
            this.cleanTemporaryConnection();
            this.endConnecting();
            return false;
        }
        if (this.theSelection.get(aRenderer.getKey()) != null) {
            return this.cleanSelectionFrom(aRenderer);
        }
        this.theSelection.put(aRenderer.getKey(), aRenderer);
        aRenderer.showSelected();
        return true;
    }

    public boolean cleanSelectionFrom(Renderer aRenderer) {
        if (this.theSelection.remove(aRenderer.getKey()) == null) {
            return false;
        }
        aRenderer.showDeselected();
        return true;
    }

    public boolean cleanSelectionAll() {
        for (String aString : this.theSelection.keySet()) {
            Renderer aRenderer = this.theSelection.get(aString);
            aRenderer.showDeselected();
        }
        this.theSelection.clear();
        return true;
    }

    public boolean select(Renderer aRenderer) {
        if (this.theSelection.containsValue(aRenderer)) {
            return true;
        }
        if (this.isConnecting) {
            return this.doConnectOnSelection(aRenderer);
        }
        this.cleanSelectionAll();
        return this.addToSelection(aRenderer);
    }

    public boolean hasSelection() {
        return !this.theSelection.isEmpty();
    }

    public JPopupMenu getSelectionMenu() {
        if (this.theSelection.isEmpty()) {
            return this.getDefaultMenu();
        }
        if (this.theSelection.size() == 1) {
            List<JMenuItem> aListMenu = null;
            JPopupMenu aPopup = new JPopupMenu();
            for (String aKey : this.theSelection.keySet()) {
                Renderer aRenderer = this.theSelection.get(aKey);
                aListMenu = aRenderer.getMenuSimple();
            }
            for (JMenuItem aMenu : aListMenu) {
                aMenu.addActionListener(this.thePanelOfConcepts);
                aPopup.add(aMenu);
            }
            return aPopup;
        }
        JPopupMenu aPopup = new JPopupMenu();
        HashMap<String, JMenuItem> aMenuMap = new HashMap<String, JMenuItem>();
        Set<String> aSetOfKey = this.theSelection.keySet();
        for (String aString : aSetOfKey) {
            Renderer aRenderer = this.theSelection.get(aString);
            List<JMenuItem> aListMenu = aRenderer.getMenuMultiple();
            for (JMenuItem aMenu : aListMenu) {
                String aName = aMenu.getActionCommand();
                if (aMenuMap.get(aName) != null) continue;
                aMenuMap.put(aName, aMenu);
                aMenu.addActionListener(this.thePanelOfConcepts);
                aPopup.add(aMenu);
            }
        }
        return aPopup;
    }

    public JPopupMenu getDefaultMenu() {
        return this.theDefaultPopup;
    }

    public void createDefaultMenu() {
        this.theDefaultPopup = new JPopupMenu();
        JMenuItem aMenu = new JMenuItem("New Goal", new ImageIcon(this.getClass().getResource("/resources/LogoGoals_16.png")));
        aMenu.addActionListener(this.thePanelOfConcepts);
        aMenu.setActionCommand("CreateInnoGoal");
        this.theDefaultPopup.add(aMenu);
        aMenu = new JMenuItem("New Problem", new ImageIcon(this.getClass().getResource("/resources/LogoProblems_16.png")));
        aMenu.addActionListener(this.thePanelOfConcepts);
        aMenu.setActionCommand("CreateInnoProblem");
        this.theDefaultPopup.add(aMenu);
        aMenu = new JMenuItem("New Domain", new ImageIcon(this.getClass().getResource("/resources/LogoDomains_16.png")));
        aMenu.addActionListener(this.thePanelOfConcepts);
        aMenu.setActionCommand("CreateInnoDomain");
        this.theDefaultPopup.add(aMenu);
        aMenu = new JMenuItem("New Solution", new ImageIcon(this.getClass().getResource("/resources/LogoSolutions_16.png")));
        aMenu.addActionListener(this.thePanelOfConcepts);
        aMenu.setActionCommand("CreateInnoSolution");
        this.theDefaultPopup.add(aMenu);
        aMenu = new JMenuItem("New Customer Segment", new ImageIcon(this.getClass().getResource("/resources/LogoClients_16.png")));
        aMenu.addActionListener(this.thePanelOfConcepts);
        aMenu.setActionCommand("CreateCustomerSegment");
        this.theDefaultPopup.add(aMenu);
        aMenu = new JMenuItem("Add Business Model", new ImageIcon(this.getClass().getResource("/resources/LogoBusinessModels_16.png")));
        aMenu.addActionListener(this.thePanelOfConcepts);
        aMenu.setActionCommand("CreateBusinessModel");
        this.theDefaultPopup.add(aMenu);
        aMenu = new JMenuItem("Toggle sliding", new ImageIcon(this.getClass().getResource("/resources/LogoHand_16.png")));
        aMenu.addActionListener(this.thePanelOfConcepts);
        aMenu.setActionCommand("ToggleSliding");
        this.theDefaultPopup.add(aMenu);
        aMenu = new JMenuItem("Set view center");
        aMenu.addActionListener(this.thePanelOfConcepts);
        aMenu.setActionCommand("Center");
        this.theDefaultPopup.add(aMenu);
    }

    public boolean executeOnApplicableSelection(String aAction) {
        if (this.isConnecting) {
            this.cleanSelectionAll();
            this.cleanTemporaryConnection();
            this.endConnecting();
            return false;
        }
        if (aAction.compareTo("Detail") == 0) {
            return this.showDetailOnSelection();
        }
        if (aAction.compareTo("Dump") == 0) {
            this.dumpOnSelection();
        } else if (aAction.compareTo("ChangeName") == 0) {
            this.changeName();
        } else if (aAction.compareTo("Delete") == 0) {
            this.deleteOnSelection();
        } else if (aAction.compareTo("Connect") == 0) {
            this.connectOnSelection();
        } else if (aAction.startsWith("StateTo")) {
            this.changeStateOnSelection(aAction);
        }
        return true;
    }

    public boolean showDetailOnSelection() {
        for (String aKey : this.theSelection.keySet()) {
            ControlConcept.showDetail(this.theSelection.get(aKey));
        }
        return true;
    }

    public boolean dumpOnSelection() {
        for (String aKey : this.theSelection.keySet()) {
            this.theSelection.get(aKey).Dump();
        }
        return true;
    }

    public boolean changeName() {
        if (this.theSelection.size() == 1) {
            for (String aKey : this.theSelection.keySet()) {
                String aName;
                Renderer aRenderer = this.theSelection.get(aKey);
                if (aRenderer.getClass() != RendererConcept.class || (aName = JOptionPane.showInputDialog("New name ?", (Object)((RendererConcept)aRenderer).getConcept().getName())) == null) continue;
                ((RendererConcept)aRenderer).getConcept().setName(aName);
                ControlConcept.updateRenderer((RendererConcept)aRenderer);
            }
            return true;
        }
        return false;
    }

    public boolean deleteOnSelection() {
        for (String aKey : this.theSelection.keySet()) {
            Renderer aRenderer = this.theSelection.get(aKey);
            if (!aRenderer.isAlive()) continue;
            ControlConcept.deleteRenderer(aRenderer);
        }
        this.cleanSelectionAll();
        return true;
    }

    public boolean changeStateOnSelection(String aStringCommand) {
        String aApplication = aStringCommand.substring(7);
        int aState = 0;
        if (aApplication.compareTo("Start") == 0) {
            aState = 2;
        } else if (aApplication.compareTo("Terminate") == 0) {
            aState = 9;
        }
        if (aState != 0) {
            for (String aKey : this.theSelection.keySet()) {
                Renderer aRenderer = this.theSelection.get(aKey);
                if (aRenderer.getClass() != RendererConcept.class) continue;
                ((RendererConcept)aRenderer).getConcept().setState(aState);
                ControlConcept.updateRenderer((RendererConcept)aRenderer);
            }
        }
        this.cleanSelectionAll();
        return true;
    }

    public void showPhantomOnSelection(int aX, int aY) {
        boolean isFirst = true;
        int aXBase = 0;
        int aYBase = 0;
        for (String aKey : this.theSelection.keySet()) {
            Renderer aRenderer = this.theSelection.get(aKey);
            if (isFirst) {
                isFirst = false;
                aXBase = this.getFocusX();
                aYBase = this.getFocusY();
            }
            aRenderer.showPhantom(aX + aRenderer.getX() - aXBase, aY + aRenderer.getY() - aYBase);
        }
    }

    public void showConnectingPhantoms(int aX, int aY) {
        for (RendererConnector aConnector : this.theTemporaryConnectors) {
            aConnector.showPhantom(aX, aY);
        }
    }

    public void hidePhantomOnSelection() {
        for (String aKey : this.theSelection.keySet()) {
            Renderer aRenderer = this.theSelection.get(aKey);
            aRenderer.hidePhantom();
        }
    }

    public boolean dragOnSelection(int aX, int aY) {
        if (this.theSelection.isEmpty()) {
            return false;
        }
        this.showPhantomOnSelection(aX, aY);
        return true;
    }

    public void setStartDrag(int aX, int aY) {
        this.theStartDragX = aX;
        this.theStartDragY = aY;
    }

    public int getStartDragX() {
        return this.theStartDragX;
    }

    public int getStartDragY() {
        return this.theStartDragY;
    }

    public void updateDragRect(Rectangle2D aBounding, int aX, int aY) {
        aBounding.setRect(aX, aY, 0.0, 0.0);
        if (this.isDragging()) {
            aBounding.add(this.getStartDragX(), this.getStartDragY());
        } else {
            this.setStartDrag(aX, aY);
            this.setDragging();
        }
    }

    public void finishDragRect(Rectangle2D aBounding, int aX, int aY) {
        aBounding.setRect(aX, aY, 0.0, 0.0);
        aBounding.add(this.getStartDragX(), this.getStartDragY());
        Interval<Integer> aIntX = new Interval<Integer>((int)aBounding.getX(), (int)(aBounding.getX() + aBounding.getWidth()));
        Interval<Integer> aIntY = new Interval<Integer>((int)aBounding.getY(), (int)(aBounding.getY() + aBounding.getHeight()));
        Interval2D<Integer> aFootPrint = new Interval2D<Integer>(aIntX, aIntY);
        List<RendererConcept> aList = this.thePanelOfConcepts.getNeighbors(aFootPrint);
        for (Renderer renderer : aList) {
            this.addToSelection(renderer);
        }
        this.endDragging();
    }

    public void setDragging() {
        this.isDragging = true;
    }

    public void endDragging() {
        this.isDragging = false;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public boolean moveToOnSelection(int aX, int aY) {
        if (this.theSelection.isEmpty()) {
            return false;
        }
        boolean isFirst = true;
        int aXBase = 0;
        int aYBase = 0;
        for (String aKey : this.theSelection.keySet()) {
            Renderer aRenderer = this.theSelection.get(aKey);
            if (isFirst) {
                isFirst = false;
                aXBase = this.getFocusX();
                aYBase = this.getFocusY();
            }
            this.thePanelOfConcepts.changePosition(aRenderer, aX + aRenderer.getX() - aXBase, aY + aRenderer.getY() - aYBase);
            aRenderer.hidePhantom();
        }
        return true;
    }

    public boolean connectOnSelection() {
        for (String aKey : this.theSelection.keySet()) {
            Renderer aRenderer = this.theSelection.get(aKey);
            if (!aRenderer.isConnectable()) continue;
            RendererConnector aConnector = new RendererConnector(aRenderer, null);
            this.theTemporaryConnectors.add(aConnector);
            this.thePanelOfConcepts.addRenderer(aConnector);
            aConnector.showPhantom(this.getFocusX(), this.getFocusY());
        }
        this.setConnecting();
        return false;
    }

    public boolean doConnectOnSelection(Renderer aRendererTarget) {
        boolean hasConnected = false;
        if (aRendererTarget.isConnectable()) {
            for (RendererConnector aConnector : this.theTemporaryConnectors) {
                if (!ControlConcept.completeConnnector(aConnector, aRendererTarget)) continue;
                hasConnected = true;
            }
        }
        this.endConnecting();
        this.cleanTemporaryConnection();
        this.cleanSelectionAll();
        return hasConnected;
    }

    public void setConnecting() {
        this.isConnecting = true;
    }

    public void endConnecting() {
        this.isConnecting = false;
    }

    public boolean isConnecting() {
        return this.isConnecting;
    }

    public void cleanTemporaryConnection() {
        for (Renderer renderer : this.theTemporaryConnectors) {
            this.thePanelOfConcepts.removeRenderer(renderer);
        }
        this.theTemporaryConnectors.clear();
    }
}

