/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideaview;

import com.xuarig.idea.InnoConcept;
import com.xuarig.ideaview.ControlConcept;
import com.xuarig.ideaview.PopupListener;
import com.xuarig.tool.Observable;
import com.xuarig.tool.Observer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class LabelOfConcept
extends JLabel
implements Observer,
MouseListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_NAME = 1;
    public static final int TYPE_DESCRIPTION = 2;
    public static final int TYPE_POSITION = 3;
    private InnoConcept theConcept = null;
    private InnoConcept theGlobalViewConcept = null;
    private int theType = 0;
    private JPopupMenu thePopup = null;
    private JMenuItem theMenuDescription = null;
    private JMenuItem theMenuDisconnect = null;
    private JMenuItem theMenuDump = null;

    public void setConcept(InnoConcept aConcept) {
        this.theConcept = aConcept;
        this.theConcept.addObserver(this);
        this.update(this.theConcept, null);
        this.setToolTipText("<html>Right click to change !<br>Left click for other actions</html>");
    }

    public void setGlobalViewConcept(InnoConcept aConcept) {
        this.theGlobalViewConcept = aConcept;
    }

    private void initiateLabelOfConcept() {
        this.addMouseListener(this);
        this.createPopup();
    }

    protected void createPopup() {
        this.thePopup = new JPopupMenu();
        this.theMenuDescription = new JMenuItem("Description");
        this.theMenuDescription.addActionListener(this);
        this.thePopup.add(this.theMenuDescription);
        this.theMenuDisconnect = new JMenuItem("Disconnect");
        this.theMenuDisconnect.addActionListener(this);
        this.thePopup.add(this.theMenuDisconnect);
        this.theMenuDump = new JMenuItem("Dump Item");
        this.theMenuDump.addActionListener(this);
        this.thePopup.add(this.theMenuDump);
        PopupListener popupListener = new PopupListener(this.thePopup);
        this.addMouseListener(popupListener);
    }

    public void setType(int aType) {
        this.theType = aType;
        this.update(this.theConcept, null);
    }

    public LabelOfConcept(InnoConcept aConcept) {
        this.setConcept(aConcept);
        this.initiateLabelOfConcept();
    }

    public LabelOfConcept() {
        this.initiateLabelOfConcept();
    }

    public LabelOfConcept(String text) {
        super(text);
        this.initiateLabelOfConcept();
    }

    public LabelOfConcept(Icon image) {
        super(image);
        this.initiateLabelOfConcept();
    }

    public LabelOfConcept(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.initiateLabelOfConcept();
    }

    public LabelOfConcept(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.initiateLabelOfConcept();
    }

    public LabelOfConcept(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.initiateLabelOfConcept();
    }

    @Override
    public void removeNotify() {
        System.out.println("Label Concept - removed for" + this.theConcept.getName());
        this.theConcept.removeObserver(this);
        super.removeNotify();
    }

    @Override
    public void update(Observable aUpdated, Observable.Change aChange) {
        System.out.println("Label Concept - run update");
        switch (this.theType) {
            case 1: {
                this.setTextHTML(this.theConcept.getName());
                System.out.println("Label Concept - update name");
                break;
            }
            case 2: {
                this.setTextHTML(this.theConcept.getDescription());
                System.out.println("Label Concept - update description");
                break;
            }
            default: {
                this.setTextHTML("not identified type of concept value");
            }
        }
    }

    public InnoConcept getConcept() {
        return this.theConcept;
    }

    @Override
    public void mouseClicked(MouseEvent aEvent) {
        System.out.println("Label Concept - Mousse Clicked");
        if ((aEvent.getModifiers() & 0x10) != 0) {
            switch (this.theType) {
                case 1: {
                    String aName = JOptionPane.showInputDialog("New name ?", (Object)this.getConcept().getName());
                    if (aName == null) break;
                    this.getConcept().setName(aName);
                    ControlConcept.updateConcept(this.getConcept());
                    break;
                }
                case 2: {
                    String aDescription = JOptionPane.showInputDialog("New Dexcription ?", (Object)this.getConcept().getDescription());
                    if (aDescription == null) break;
                    this.getConcept().setDescription(aDescription);
                    ControlConcept.updateConcept(this.getConcept());
                    break;
                }
                default: {
                    this.setTextHTML("type of concept cannot be changed");
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        System.out.println("Label Concept - Mousse Entered");
    }

    @Override
    public void mouseExited(MouseEvent e) {
        System.out.println("Label Concept - Mousse exited");
    }

    @Override
    public void mousePressed(MouseEvent e) {
        System.out.println("Label Concept - Mousse Pressed");
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        System.out.println("Label Concept - Mousse Released");
    }

    public void setTextHTML(String aText) {
        this.setText("<html>" + aText + "</html>");
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        System.out.println("LabelOfConcept - Action Performed");
        if (this.theConcept == null) {
            return;
        }
        if (aEvent.getSource() == this.theMenuDescription) {
            this.actionPerformedDescription(aEvent);
        } else if (aEvent.getSource() == this.theMenuDisconnect) {
            this.actionPerformedDisconnect(aEvent);
        } else if (aEvent.getSource() == this.theMenuDump) {
            this.actionPerformedDump(aEvent);
        }
    }

    public void actionPerformedDescription(ActionEvent aEvent) {
        String aDescription;
        System.out.println("LabelOfConcept - Action Performed Description");
        if (this.getConcept() != null && (aDescription = JOptionPane.showInputDialog("Description ?", (Object)this.getConcept().getDescription())) != null) {
            this.getConcept().setDescription(aDescription);
            this.getConcept().setChanged(Observable.Change.CORECHANGED, "Description");
            ControlConcept.updateConcept(this.getConcept());
        }
    }

    public void actionPerformedDisconnect(ActionEvent aEvent) {
        System.out.println("Label of Concept - Action Performed Disconnect from global view");
        ControlConcept.separateConcepts(this.theGlobalViewConcept, this.theConcept);
        this.theGlobalViewConcept = null;
    }

    public void actionPerformedDump(ActionEvent aEvent) {
        System.out.println("LabelOfConcept - Action Performed Dump");
        if (this.getConcept() != null) {
            this.getConcept().dump();
        }
    }
}

