/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideaview;

import com.xuarig.idea.InnoConcept;
import com.xuarig.idea.InnoDomain;
import com.xuarig.ideaview.ControlConcept;
import com.xuarig.ideaview.InteractorPanelOfConcepts;
import com.xuarig.ideaview.PanelOfConceptAdapter;
import com.xuarig.ideaview.PopupInteractorListener;
import com.xuarig.ideaview.RendererConcept;
import com.xuarig.princetontool.Interval2D;
import com.xuarig.princetontool.QuadTree;
import com.xuarig.tool.Observable;
import com.xuarig.tool.Observer;
import com.xuarig.tool.Renderer;
import com.xuarig.tool.RendererConnector;
import com.xuarig.tool.ViewForRenderer;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PanelOfConcepts
extends JPanel
implements MouseListener,
ActionListener,
MouseMotionListener,
KeyListener,
ViewForRenderer,
Observer,
MouseWheelListener {
    private static final long serialVersionUID = 3824825434855062918L;
    private InnoDomain theDomain = null;
    private List<Renderer> theRenderers;
    private Map<String, Renderer> theLinks = new HashMap<String, Renderer>();
    private Renderer thePressedRenderer;
    private QuadTree<Integer, RendererConcept> theQuadTree;
    private int thePressedX;
    private int thePressedY;
    private int theBaseMove = 50;
    private boolean isDragged = false;
    private boolean isSliding = false;
    private Rectangle2D theSelectionRectangle = new Rectangle();
    private double theXPlanCentre = 0.0;
    private double theYPlanCentre = 0.0;
    private double theScale = 1.0;
    private double theScaleVelocity = 1.25;
    private boolean isShiftPressed = false;
    private boolean isCtrlPressed = false;
    private InteractorPanelOfConcepts theInteractor = new InteractorPanelOfConcepts(this);
    private Map<String, String> theConceptTypes = new HashMap<String, String>();
    ScheduledExecutorService theServiceTime = Executors.newSingleThreadScheduledExecutor();

    private final void initiateInnoPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(new PanelOfConceptAdapter());
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.addKeyListener(this);
        this.theXPlanCentre = this.getWidth() / 2;
        this.theYPlanCentre = this.getHeight() / 2;
        this.theRenderers = new ArrayList<Renderer>();
        this.setBackground(Color.white);
        this.createPopupListener();
        this.initiateConceptTypes();
        this.theServiceTime.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                PanelOfConcepts.this.repaint();
            }
        }, 1000L, 50L, TimeUnit.MILLISECONDS);
    }

    protected void initiateConceptTypes() {
        this.theConceptTypes.put("InnoConcept", "com.xuarig.idea.InnoConcept");
        this.theConceptTypes.put("InnoSolution", "com.xuarig.idea.InnoSolution");
        this.theConceptTypes.put("InnoGoal", "com.xuarig.idea.InnoGoal");
        this.theConceptTypes.put("InnoProblem", "com.xuarig.idea.InnoProblem");
        this.theConceptTypes.put("InnoDomain", "com.xuarig.idea.InnoDomain");
        this.theConceptTypes.put("CustomerSegment", "com.xuarig.businessmodel.BusinessCustomerSegment");
        this.theConceptTypes.put("BusinessModel", "com.xuarig.businessmodel.BusinessModel");
    }

    protected void createPopupListener() {
        PopupInteractorListener popupListener = new PopupInteractorListener(this.theInteractor);
        this.addMouseListener(popupListener);
    }

    public void setDomainView(InnoDomain aDomain) {
        this.theDomain = aDomain;
        this.update(aDomain, Observable.Change.INITOBSERVER);
        aDomain.addObserver(this);
    }

    public InnoDomain getDomainView() {
        return this.theDomain;
    }

    public PanelOfConcepts() {
        this.initiateInnoPanel();
    }

    public PanelOfConcepts(LayoutManager layout) {
        super(layout);
        this.initiateInnoPanel();
    }

    public PanelOfConcepts(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.initiateInnoPanel();
    }

    public PanelOfConcepts(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
        this.initiateInnoPanel();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int aLayer = 0;
        while (aLayer < 4) {
            for (Renderer aRenderer : this.theRenderers) {
                if (aRenderer.getDrawingPriority() != aLayer) continue;
                aRenderer.Paint(g);
            }
            ++aLayer;
        }
        if (this.theInteractor.isDragging()) {
            g.drawRect((int)this.theSelectionRectangle.getX(), (int)this.theSelectionRectangle.getY(), (int)this.theSelectionRectangle.getWidth(), (int)this.theSelectionRectangle.getHeight());
        }
    }

    @Override
    public void mouseMoved(MouseEvent aEvent) {
        if (this.theInteractor.isConnecting()) {
            this.theInteractor.showConnectingPhantoms(aEvent.getX(), aEvent.getY());
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent aEvent) {
        System.out.println("Mouse - Dragged");
        if ((aEvent.getModifiers() & 0x10) != 0) {
            this.dragLeft(aEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent aEvent) {
        System.out.println("Mouse - Clicked");
        if ((aEvent.getModifiers() & 0x10) != 0) {
            this.clickLeft(aEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent aEvent) {
        System.out.println("Mouse - Pressed");
        this.thePressedX = aEvent.getX();
        this.thePressedY = aEvent.getY();
        this.thePressedRenderer = null;
        this.theInteractor.setFocus(this.thePressedX, this.thePressedY);
        if (!this.isSliding()) {
            this.thePressedRenderer = this.isIn(this.thePressedX, this.thePressedY);
        }
        if (this.thePressedRenderer != null) {
            System.out.println("Mousse Pressed - found Renderer / shift: " + this.isShiftPressed + "Ctrl: " + this.isCtrlPressed);
            if (aEvent.isShiftDown() || aEvent.isControlDown()) {
                this.theInteractor.addToSelection(this.thePressedRenderer);
            } else {
                this.theInteractor.select(this.thePressedRenderer);
            }
        } else {
            this.theInteractor.cleanSelectionAll();
        }
        this.repaint();
        this.thePressedRenderer = null;
        if ((aEvent.getModifiers() & 0x10) != 0) {
            this.pressLeft(aEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent aEvent) {
        if ((aEvent.getModifiers() & 0x10) != 0) {
            this.releaseLeft(aEvent);
        }
    }

    public void createFromCommand(String aCreateCommand) {
        String aQueryType = aCreateCommand.substring(6, aCreateCommand.length());
        String aTypeOfConcept = this.theConceptTypes.get(aQueryType);
        if (aTypeOfConcept == null) {
            return;
        }
        String aName = JOptionPane.showInputDialog("New name ?");
        if (aName != null) {
            ControlConcept.createConceptOfType(aTypeOfConcept, this.theDomain, aName, this.computeViewX(this.thePressedX), this.computeViewY(this.thePressedY));
        }
    }

    @Override
    public void actionPerformed(ActionEvent aEvent) {
        System.out.println("Action Performed: " + aEvent.getActionCommand());
        if (aEvent.getActionCommand().startsWith("Create")) {
            this.createFromCommand(aEvent.getActionCommand());
        } else if (aEvent.getActionCommand().compareTo("Center") == 0) {
            this.moveCenterPlan(this.thePressedX, this.thePressedY);
        } else if (aEvent.getActionCommand().compareTo("ToggleSliding") == 0) {
            if (this.isSliding()) {
                this.endSliding();
            } else {
                this.setSliding();
            }
            this.theInteractor.cleanSelectionAll();
        } else {
            this.theInteractor.executeOnApplicableSelection(aEvent.getActionCommand());
        }
        this.repaint();
    }

    public Renderer isIn(int aX, int aY) {
        for (Renderer aRenderer : this.theRenderers) {
            if (!aRenderer.isIn(aX, aY)) continue;
            return aRenderer;
        }
        return null;
    }

    public void dragLeft(MouseEvent aEvent) {
        System.out.println("Drag - Left");
        int aX = aEvent.getX();
        int aY = aEvent.getY();
        if (!this.isSliding) {
            if (this.theInteractor.hasSelection()) {
                this.theInteractor.dragOnSelection(aX, aY);
            } else {
                this.theInteractor.updateDragRect(this.theSelectionRectangle, aX, aY);
            }
        } else {
            this.translateCenterPlan(-aX + this.thePressedX, -aY + this.thePressedY);
            this.thePressedX = aX;
            this.thePressedY = aY;
        }
        this.isDragged = true;
        this.repaint();
    }

    public void clickLeft(MouseEvent aEvent) {
        System.out.println("Click - Left");
    }

    public void releaseLeft(MouseEvent aEvent) {
        System.out.println("Release - Left");
        int aX = aEvent.getX();
        int aY = aEvent.getY();
        if (this.isDragged) {
            if (!this.isSliding) {
                if (this.theInteractor.hasSelection()) {
                    this.theInteractor.moveToOnSelection(aX, aY);
                } else {
                    this.theInteractor.finishDragRect(this.theSelectionRectangle, aX, aY);
                }
            } else {
                this.translateCenterPlan(-aX + this.thePressedX, -aY + this.thePressedY);
            }
        }
        this.isDragged = false;
        this.repaint();
    }

    public void pressLeft(MouseEvent aEvent) {
        System.out.println("Mouse - Pressed");
    }

    @Override
    public void removeRenderer(Renderer aRenderer) {
        this.theRenderers.remove(aRenderer);
        this.theLinks.remove(aRenderer.getKey());
        if (aRenderer instanceof RendererConcept) {
            ((RendererConcept)aRenderer).getConcept().removeObserver(this);
        }
        this.repaint();
    }

    @Override
    public void addRenderer(Renderer aRenderer) {
        aRenderer.changeProjection(this.getWidth() / 2, this.getHeight() / 2, this.theXPlanCentre, this.theYPlanCentre, this.theScale);
        this.theRenderers.add(aRenderer);
        this.theLinks.put(aRenderer.getKey(), aRenderer);
        if (aRenderer instanceof RendererConcept) {
            ((RendererConcept)aRenderer).getConcept().addObserver(this);
        }
        aRenderer.setView(this);
    }

    public void zoomIn() {
        this.theScale *= this.theScaleVelocity;
        this.computeProjection();
        this.repaint();
    }

    public void zoomOut() {
        this.theScale /= this.theScaleVelocity;
        this.computeProjection();
        this.repaint();
    }

    public void moveCenterPlan(int aXView, int aYView) {
        this.theXPlanCentre = (double)(aXView - this.getWidth() / 2) / this.theScale + this.theXPlanCentre;
        this.theYPlanCentre = (double)(aYView - this.getHeight() / 2) / this.theScale + this.theYPlanCentre;
        this.computeProjection();
        this.repaint();
    }

    public void translateCenterPlan(int aDXView, int aDYView) {
        this.theXPlanCentre = (double)aDXView / this.theScale + this.theXPlanCentre;
        this.theYPlanCentre = (double)aDYView / this.theScale + this.theYPlanCentre;
        this.computeProjection();
        this.repaint();
    }

    protected void changePosition(Renderer aRenderer, int aXView, int aYView) {
        double aX = this.computeViewX(aXView);
        double aY = this.computeViewY(aYView);
        ControlConcept.changePosition(aRenderer, aX, aY);
    }

    protected double computeViewX(int aXView) {
        return (double)(aXView - this.getWidth() / 2) / this.theScale + this.theXPlanCentre;
    }

    protected double computeViewY(int aYView) {
        return (double)(aYView - this.getHeight() / 2) / this.theScale + this.theYPlanCentre;
    }

    protected void computeProjection() {
        this.theQuadTree = new QuadTree();
        for (Renderer aRenderer : this.theRenderers) {
            aRenderer.changeProjection(this.getWidth() / 2, this.getHeight() / 2, this.theXPlanCentre, this.theYPlanCentre, this.theScale);
            if (aRenderer.getClass() != RendererConcept.class) continue;
            this.theQuadTree.insert(aRenderer.getX(), aRenderer.getY(), (RendererConcept)aRenderer);
        }
        for (Renderer aRenderer : this.theRenderers) {
            aRenderer.computeDrawingPriority(this.getGraphics());
        }
    }

    public List<RendererConcept> getNeighbors(Interval2D<Integer> aRect) {
        if (this.theQuadTree != null) {
            return this.theQuadTree.query2D(aRect);
        }
        return null;
    }

    public void resetCenter() {
        this.moveCenterPlan(this.getWidth() / 2, this.getHeight() / 2);
    }

    @Override
    public void update(Observable aUpdated, Observable.Change aChange) {
        System.out.println("Panel of Concept - update view on Domain");
        if (aChange == Observable.Change.INITOBSERVER) {
            this.initDomainRenderers();
            this.repaint();
        } else if (aChange == Observable.Change.CORECHANGED) {
            System.out.println("Panel of Concept - CORECHANGED");
            if (this.theDomain.getChangeContext() == "AddComponent") {
                this.addViewOnNewConcepts();
                this.computeProjection();
                this.repaint();
                System.out.println("Panel of Concept - AddComponent");
            }
            if (aUpdated.getChangeContext() == "Position") {
                this.computeProjection();
            }
        } else if (aChange == Observable.Change.CHANGED && aUpdated.getChangeContext() == "MadeFriend" && aUpdated instanceof InnoConcept) {
            this.addViewOnNewConnectors((InnoConcept)aUpdated);
            this.computeProjection();
            this.repaint();
        }
    }

    protected void addViewOnNewConcepts() {
        for (InnoConcept aConcept : this.theDomain.getComponents()) {
            if (this.theLinks.get(RendererConcept.makeKey(aConcept)) != null) continue;
            System.out.println("Add view on new concept - New concept found " + aConcept.getName());
            RendererConcept aRenderer = new RendererConcept(aConcept);
            this.addRenderer(aRenderer);
        }
    }

    protected void addViewOnNewConnectors(InnoConcept aConcept) {
        for (InnoConcept aFriendConcept : aConcept.getFriends()) {
            String aKey = RendererConcept.makeConnectedKey(aConcept, aFriendConcept);
            Renderer aRenderer = this.theLinks.get(aKey);
            if (aRenderer != null) continue;
            System.out.println("Add new connector - New link found " + aKey);
            Renderer aRendererA = this.theLinks.get(RendererConcept.makeKey(aConcept));
            Renderer aRendererB = this.theLinks.get(RendererConcept.makeKey(aFriendConcept));
            aRenderer = new RendererConnector(aRendererA, aRendererB);
            aConcept.addObserver(aRenderer);
            aFriendConcept.addObserver(aRenderer);
            this.addRenderer(aRenderer);
        }
    }

    public void initDomainRenderers() {
        List<Renderer> aListRenderers = ControlConcept.initDomainRenderers(this.getDomainView());
        for (Renderer aRenderer : aListRenderers) {
            this.addRenderer(aRenderer);
        }
        System.out.println("PanelConcept - Renderers for Domain Created");
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent aEvent) {
        if (aEvent.getWheelRotation() > 0) {
            this.zoomIn();
        } else if (aEvent.getWheelRotation() < 0) {
            this.zoomOut();
        }
    }

    @Override
    public void keyPressed(KeyEvent aEvent) {
        int aCode = aEvent.getKeyCode();
        if (aCode == 34) {
            this.zoomOut();
        } else if (aCode == 33) {
            this.zoomIn();
        } else if (aCode == 38) {
            this.translateCenterPlan(0, -this.theBaseMove);
        } else if (aCode == 40) {
            this.translateCenterPlan(0, this.theBaseMove);
        } else if (aCode == 39) {
            this.translateCenterPlan(this.theBaseMove, 0);
        } else if (aCode == 37) {
            this.translateCenterPlan(-this.theBaseMove, 0);
        } else if (aCode == 27) {
            this.endSliding();
        }
    }

    @Override
    public void keyReleased(KeyEvent aEvent) {
    }

    @Override
    public void keyTyped(KeyEvent aEvent) {
    }

    public void setSliding() {
        this.isSliding = true;
        this.setCursor(new Cursor(12));
    }

    public void endSliding() {
        this.isSliding = false;
        this.setCursor(new Cursor(0));
    }

    public boolean isSliding() {
        return this.isSliding;
    }
}

