/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.ideaview;

import com.xuarig.businessmodel.BusinessCustomerSegment;
import com.xuarig.businessmodel.BusinessModel;
import com.xuarig.idea.InnoConcept;
import com.xuarig.idea.InnoGoal;
import com.xuarig.idea.InnoProblem;
import com.xuarig.idea.InnoSolution;
import com.xuarig.ideaview.ControlConcept;
import com.xuarig.ideaview.PanelOfConcepts;
import com.xuarig.princetontool.Interval;
import com.xuarig.princetontool.Interval2D;
import com.xuarig.tool.Observable;
import com.xuarig.tool.Renderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class RendererConcept
extends Renderer {
    protected static Color theProblemColorBase = new Color(255, 100, 100);
    protected static Color theProblemColorReflection = new Color(255, 200, 200);
    protected static Color theProblemColorLabel = new Color(255, 200, 200, 50);
    protected static Color theProblemColorBeacon = new Color(255, 10, 10, 20);
    protected static Color theProblemColorBlink = new Color(255, 0, 0, 70);
    protected static Color theSolutionColorBase = new Color(100, 100, 255);
    protected static Color theSolutionColorReflection = new Color(200, 200, 255);
    protected static Color theSolutionColorLabel = new Color(200, 200, 255, 50);
    protected static Color theGoalColorBase = new Color(100, 255, 100);
    protected static Color theGoalColorReflection = new Color(200, 255, 200);
    protected static Color theGoalColorLabel = new Color(200, 255, 200, 50);
    protected static Color theBusinessModelColorBase = new Color(255, 100, 0);
    protected static Color theBusinessModelColorReflection = new Color(255, 200, 0);
    protected static Color theBusinessModelColorLabel = new Color(255, 200, 0, 50);
    protected static Color theCustomerSegmentColorBase = new Color(100, 0, 255);
    protected static Color theCustomerSegmentColorReflection = new Color(200, 0, 255);
    protected static Color theCustomerSegmentColorLabel = new Color(200, 0, 255, 50);
    protected InnoConcept theConcept;
    private int theBeaconRadius = 0;
    private int theBeaconPhase = 0;
    private int theMaxWidth = 30;
    private int theMaxLine = 4;
    private String[] theBreakdown = null;
    private Rectangle2D theBoundaries = new Rectangle();

    public RendererConcept(InnoConcept aConcept) {
        this.theConcept = aConcept;
        this.theConcept.addObserver(this);
        this.isDraggable = true;
        this.isConnectable = true;
        this.theDrawingPriority = 1;
        this.breakdownName();
    }

    public InnoConcept getConcept() {
        return this.theConcept;
    }

    @Override
    protected void computeProjection() {
        this.theXPlan = this.theConcept.getParticle().getPosition().getX();
        this.theYPlan = this.theConcept.getParticle().getPosition().getY();
        super.computeProjection();
    }

    @Override
    public void Paint(Graphics g) {
        if (!g.hitClip(this.theX, this.theY, 2, 2)) {
            return;
        }
        Color aColorParticle = Color.darkGray;
        Color aColorArc = Color.lightGray;
        Color aColorLabel = new Color(100, 100, 100, 50);
        if (this.theConcept.getClass() == InnoSolution.class) {
            aColorParticle = theSolutionColorBase;
            aColorArc = theSolutionColorReflection;
            aColorLabel = theSolutionColorLabel;
        } else if (this.theConcept.getClass() == InnoProblem.class) {
            aColorParticle = theProblemColorBase;
            aColorArc = theProblemColorReflection;
            aColorLabel = theProblemColorLabel;
        } else if (this.theConcept.getClass() == InnoGoal.class) {
            aColorParticle = theGoalColorBase;
            aColorArc = theGoalColorReflection;
            aColorLabel = theGoalColorLabel;
        } else if (this.theConcept.getClass() == BusinessModel.class) {
            aColorParticle = theBusinessModelColorBase;
            aColorArc = theBusinessModelColorReflection;
            aColorLabel = theBusinessModelColorLabel;
        } else if (this.theConcept.getClass() == BusinessCustomerSegment.class) {
            aColorParticle = theCustomerSegmentColorBase;
            aColorArc = theCustomerSegmentColorReflection;
            aColorLabel = theCustomerSegmentColorLabel;
        }
        Color aColorSelection = aColorParticle.darker();
        Graphics2D g2 = (Graphics2D)g;
        if (this.isSelected) {
            g.setColor(aColorSelection);
            g.fillOval(this.theX - ((int)this.theRadius + this.theSelectionBorder), this.theY - ((int)this.theRadius + this.theSelectionBorder), ((int)this.theRadius + this.theSelectionBorder) * 2, ((int)this.theRadius + this.theSelectionBorder) * 2);
        }
        Font font = new Font("Arial", 1, 9);
        g.setFont(font);
        List<RendererConcept> aList = this.getNeighbors(g);
        Rectangle2D aRect = this.getBoundaries();
        if (aList == null) {
            return;
        }
        if (aList.size() < 4 && this.theConcept.getState() != 9) {
            g.setColor(aColorParticle);
            g.fillOval(this.theX - (int)this.theRadius, this.theY - (int)this.theRadius, (int)this.theRadius * 2, (int)this.theRadius * 2);
            g.setColor(aColorArc);
            g2.draw(new Arc2D.Double(this.theX - ((int)this.theRadius - 2), this.theY - ((int)this.theRadius - 2), ((int)this.theRadius - 2) * 2, ((int)this.theRadius - 2) * 2, 90.0, 110.0, 0));
            g.setColor(aColorLabel);
            FontMetrics aGauge = g.getFontMetrics();
            g.fillRect(this.theX - (int)aRect.getWidth() / 2, this.theY + (int)this.theRadius + aGauge.getDescent(), (int)aRect.getWidth(), (int)aRect.getHeight());
            if (aList.size() > 1) {
                g.setColor(aColorArc);
            } else {
                g.setColor(Color.black);
            }
            if (aList.size() < 3) {
                this.showStringLimited(g, this.theBreakdown, this.theX, this.theY, this.theMaxLine);
            }
        } else {
            Color aColorTemp = this.theConcept.getState() == 9 ? new Color(aColorParticle.getRed(), aColorParticle.getGreen(), aColorParticle.getBlue(), 40) : aColorParticle;
            g.setColor(aColorTemp);
            g.fillOval(this.theX - (int)this.theRadius / 2, this.theY - (int)this.theRadius / 2, (int)this.theRadius / 2 * 2, (int)this.theRadius / 2 * 2);
        }
        if (this.hasPhantom()) {
            Color aColorPhantom = Color.gray;
            g.setColor(aColorPhantom);
            g.drawOval(this.getPhantomX() - (int)this.theRadius, this.getPhantomY() - (int)this.theRadius, (int)this.theRadius * 2, (int)this.theRadius * 2);
            font = new Font("Arial", 2, 8);
            this.showStringLimited(g, this.theBreakdown, this.getPhantomX(), this.getPhantomY(), this.theMaxLine);
        }
    }

    @Override
    public void computeDrawingPriority(Graphics g) {
        Font font = new Font("Arial", 1, 9);
        g.setFont(font);
        List<RendererConcept> aList = this.getNeighbors(g);
        if (aList != null) {
            if (aList.size() == 1) {
                this.setDrawingPriority(3);
            } else if (aList.size() < 3) {
                this.setDrawingPriority(2);
            } else {
                this.setDrawingPriority(1);
            }
        }
    }

    public Rectangle2D getBoundaries() {
        return this.theBoundaries;
    }

    public List<RendererConcept> getNeighbors(Graphics g) {
        FontMetrics aGauge = g.getFontMetrics();
        int aMaxWidth = 0;
        int aIndex = 0;
        while (aIndex < this.theMaxLine) {
            if (this.theBreakdown[aIndex] == null) break;
            Rectangle2D aRect = aGauge.getStringBounds(this.theBreakdown[aIndex], g);
            aMaxWidth = Math.max((int)aRect.getWidth(), aMaxWidth);
            ++aIndex;
        }
        this.theBoundaries.setRect(0.0, 0.0, aMaxWidth, aGauge.getHeight() * (--aIndex + 1));
        Interval<Integer> aIntX = new Interval<Integer>(this.theX - aMaxWidth / 2, this.theX + aMaxWidth / 2);
        Interval<Integer> aIntY = new Interval<Integer>(this.theY - (int)this.theRadius, this.theY + (int)this.theBoundaries.getHeight() + (int)this.theRadius + aGauge.getDescent());
        Interval2D<Integer> aFootPrint = new Interval2D<Integer>(aIntX, aIntY);
        List<RendererConcept> aList = ((PanelOfConcepts)this.getView()).getNeighbors(aFootPrint);
        return aList;
    }

    public void showBeacon(Graphics g) {
        switch (this.theBeaconPhase) {
            case 0: {
                ++this.theBeaconRadius;
                if (this.theBeaconRadius > 20) {
                    this.theBeaconRadius = 0;
                    ++this.theBeaconPhase;
                }
                g.setColor(theProblemColorBeacon);
                break;
            }
            case 1: {
                this.theBeaconRadius += 4;
                if (this.theBeaconRadius > 15) {
                    this.theBeaconRadius = 0;
                    ++this.theBeaconPhase;
                }
                g.setColor(theProblemColorBlink);
                break;
            }
            default: {
                this.theBeaconPhase = 0;
            }
        }
        g.fillOval(this.theX - this.theBeaconRadius, this.theY - this.theBeaconRadius, this.theBeaconRadius * 2, this.theBeaconRadius * 2);
    }

    public void showStringLimited(Graphics g, String[] aBreakdown, int aX, int aY, int aMaxLine) {
        FontMetrics aGauge = g.getFontMetrics();
        int aIndex = 0;
        while (aIndex < aMaxLine) {
            if (aBreakdown[aIndex] != null) {
                g.drawString(aBreakdown[aIndex], aX - aGauge.stringWidth(aBreakdown[aIndex]) / 2, aY + (int)this.theRadius + (aIndex + 1) * aGauge.getHeight());
            }
            ++aIndex;
        }
    }

    public static void breakdownString(String[] aBreakdown, String aStringToSlice, int aIndex, int aMaxChar, int aMaxLine) {
        if (aStringToSlice.length() <= aMaxChar) {
            aBreakdown[aIndex] = aStringToSlice;
            return;
        }
        int aPosition = aStringToSlice.lastIndexOf(32, aMaxChar - 1);
        if (aPosition < 0) {
            aPosition = aMaxChar - 1;
        }
        aBreakdown[aIndex] = aStringToSlice.substring(0, aPosition + 1);
        if (aMaxLine != 0) {
            RendererConcept.breakdownString(aBreakdown, aStringToSlice.substring(aPosition + 1), aIndex + 1, aMaxChar, aMaxLine - 1);
        } else {
            aBreakdown[aIndex] = String.valueOf(aBreakdown[aIndex]) + "...";
        }
    }

    public static String[] breakdownString(String aString, int aMaxChar, int aMaxLine) {
        String[] aBreakdown = new String[aMaxLine];
        RendererConcept.breakdownString(aBreakdown, aString, 0, aMaxChar, aMaxLine - 1);
        return aBreakdown;
    }

    public void breakdownName() {
        this.theBreakdown = RendererConcept.breakdownString(this.theConcept.getName(), this.theMaxWidth, this.theMaxLine);
    }

    @Override
    public void Dump() {
        super.Dump();
        ControlConcept.dump(this);
    }

    @Override
    public boolean isFriend(Renderer aRenderer) {
        InnoConcept aConcept;
        return aRenderer.getClass() == RendererConcept.class && this.theConcept.isConnected(aConcept = ((RendererConcept)aRenderer).getConcept());
    }

    @Override
    public void update(Observable aUpdated, Observable.Change aChange) {
        super.update(aUpdated, aChange);
        System.out.println("Renderer Concept - Updated");
        if (aUpdated.getChangeContext() == "Position") {
            this.computeProjection();
            System.out.println("Renderer Concept - Projection computed");
        } else {
            this.breakdownName();
        }
    }

    @Override
    public String getKey() {
        return RendererConcept.makeKey(this.theConcept);
    }

    public static String makeKey(InnoConcept aConcept) {
        return "" + aConcept.getId();
    }

    @Override
    protected String makeConnectedKey(Renderer aRendererB) {
        String aKey = "Fatal Error";
        if (aRendererB == null) {
            return "T" + this.theConcept.getId();
        }
        if (aRendererB.getClass() == RendererConcept.class) {
            InnoConcept aConceptB = ((RendererConcept)aRendererB).theConcept;
            aKey = RendererConcept.makeConnectedKey(this.theConcept, aConceptB);
        }
        return aKey;
    }

    public static String makeConnectedKey(InnoConcept aConceptA, InnoConcept aConceptB) {
        String aKey = "";
        aKey = aConceptA.getId() > aConceptB.getId() ? "C" + aConceptB.getId() + "-" + aConceptA.getId() : "C" + aConceptA.getId() + "-" + aConceptB.getId();
        return aKey;
    }

    @Override
    public List<JMenuItem> getMenuMultiple() {
        ArrayList<JMenuItem> aListMenu = new ArrayList<JMenuItem>();
        JMenuItem aMenu = new JMenuItem("Connect");
        aMenu.setActionCommand("Connect");
        aListMenu.add(aMenu);
        aMenu = new JMenuItem("Show detail");
        aMenu.setActionCommand("Detail");
        aListMenu.add(aMenu);
        aMenu = new JMenuItem("Terminate");
        aMenu.setActionCommand("StateToTerminate");
        aListMenu.add(aMenu);
        aMenu = new JMenuItem("Start");
        aMenu.setActionCommand("StateToStart");
        aListMenu.add(aMenu);
        aMenu = new JMenuItem("Dump item(s)");
        aMenu.setActionCommand("Dump");
        aListMenu.add(aMenu);
        aMenu = new JMenuItem("Delete");
        aMenu.setActionCommand("Delete");
        aListMenu.add(aMenu);
        return aListMenu;
    }

    @Override
    public List<JMenuItem> getMenuSimple() {
        List<JMenuItem> aListMenu = this.getMenuMultiple();
        JMenuItem aMenu = new JMenuItem("Change Name");
        aMenu.setActionCommand("ChangeName");
        aListMenu.add(aMenu);
        return aListMenu;
    }
}

