/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.physique;

import com.xuarig.physique.ElectrostaticField;
import com.xuarig.physique.MVector3;
import com.xuarig.physique.Particle;

public class Monde {
    private static Particle[] theWorldElement;
    private static int theSize;
    private static double theXlimit;
    private static double theYlimit;

    static {
        theXlimit = 500.0;
        theYlimit = 600.0;
    }

    Monde() {
        theSize = 100;
        theWorldElement = new Particle[theSize];
        int aIndex = 0;
        while (aIndex < theSize) {
            Monde.theWorldElement[aIndex] = new Particle(1.0, 1.0);
            theWorldElement[aIndex].setPosition(new MVector3(300.0 + 200.0 * Math.cos((double)(aIndex / 100) * Math.PI / 180.0), 200.0 + 200.0 * Math.sin((double)(aIndex / 100) * Math.PI / 180.0), 0.0));
            ++aIndex;
        }
    }

    public static MVector3 calculateEnvInfluence(Particle aParticule) {
        MVector3 aInfluence = new MVector3(0.0, 0.0, 0.0);
        int aIndex = 0;
        while (aIndex < theSize) {
            if (theWorldElement[aIndex] != aParticule) {
                aInfluence.Add(ElectrostaticField.calculateInfluenceAonB(theWorldElement[aIndex], aParticule));
            }
            ++aIndex;
        }
        return aInfluence;
    }

    public static void Box(Particle aParticule) {
        MVector3 aPosition = aParticule.getPosition();
        MVector3 aSpeed = aParticule.getSpeed();
        double aX = aPosition.getX();
        double aY = aPosition.getY();
        double aZ = aPosition.getZ();
        double aVX = aSpeed.getX();
        double aVY = aSpeed.getY();
        double aVZ = aSpeed.getZ();
        if (aX < 0.0) {
            aSpeed.setCoord(-aVX, aVY, aVZ);
        }
        if (aX > theXlimit) {
            aSpeed.setCoord(-aVX, aVY, aVZ);
        }
        if (aY < 0.0) {
            aSpeed.setCoord(aVX, -aVY, aVZ);
        }
        if (aY > theYlimit) {
            aSpeed.setCoord(aVX, -aVY, aVZ);
        }
    }
}

