/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.physique;

import com.xuarig.physique.MVector;
import com.xuarig.physique.MVector3;
import com.xuarig.physique.Monde;
import java.io.Serializable;

public class Particle
implements Serializable {
    private static final long serialVersionUID = 4983450060695694635L;
    private double theCharge;
    private double theMass;
    private MVector3 thePosition;
    private MVector3 theSpeed;
    private MVector3 theAcceleration;

    public Particle(double aCharge, double aMass) {
        this.setCharge(aCharge);
        this.setMass(aMass);
        this.thePosition = new MVector3();
        this.theSpeed = new MVector3();
        this.theAcceleration = new MVector3();
    }

    public double getCharge() {
        return this.theCharge;
    }

    public void setCharge(double aCharge) {
        this.theCharge = aCharge;
    }

    public double getMass() {
        return this.theMass;
    }

    public void setMass(double aMass) {
        this.theMass = aMass;
    }

    public MVector3 getPosition() {
        return this.thePosition;
    }

    public void setPosition(MVector3 aVector) {
        this.thePosition.Equal(aVector);
    }

    public void setPosition(double aX, double aY, double aZ) {
        this.thePosition.setCoord(aX, aY, aZ);
    }

    public void calculateInfluence() {
        MVector3 aInfluence = Monde.calculateEnvInfluence(this);
        this.theAcceleration.DivideEqual(aInfluence, this.getMass());
    }

    public void setSpeed(double aX, double aY, double aZ) {
        this.theSpeed.setCoord(aX, aY, aZ);
    }

    public MVector3 getSpeed() {
        return this.theSpeed;
    }

    public void setInfluence(MVector3 aInfluence) {
        this.theAcceleration.Equal(aInfluence);
        this.theAcceleration.DivideEqual(this.theAcceleration, this.getMass());
    }

    public MVector3 getAcceleration() {
        return this.theAcceleration;
    }

    public void calculateNewSpeed(double aDeltaT) {
        MVector3 aSpeedVariation = new MVector3();
        aSpeedVariation.MultiplyEqual((MVector)this.getAcceleration(), aDeltaT);
        this.theSpeed.AddEqual(this.theSpeed, aSpeedVariation);
    }

    public void calculateNewPosition(double aDeltaT) {
        MVector3 aPositionVariation = new MVector3();
        aPositionVariation.MultiplyEqual((MVector)this.getSpeed(), aDeltaT);
        this.thePosition.AddEqual(this.thePosition, aPositionVariation);
    }

    public void EnOld(double aDeltaT) {
        this.calculateNewPosition(aDeltaT);
        this.calculateNewSpeed(aDeltaT);
    }

    public double getX() {
        return this.thePosition.getX();
    }

    public double getY() {
        return this.thePosition.getY();
    }

    public double getZ() {
        return this.thePosition.getZ();
    }
}

