/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.princetontool;

public class Interval<Key extends Comparable> {
    public final Key low;
    public final Key high;

    public Interval(Key low, Key high) {
        if (this.less(high, low)) {
            throw new RuntimeException("Illegal argument");
        }
        this.low = low;
        this.high = high;
    }

    public boolean contains(Key x) {
        return !this.less(x, this.low) && !this.less(this.high, x);
    }

    public boolean intersects(Interval<Key> b) {
        Interval a = this;
        if (this.less(a.high, b.low)) {
            return false;
        }
        return !this.less(b.high, a.low);
    }

    public boolean equals(Interval<Key> b) {
        Interval a = this;
        return a.low.equals(b.low) && a.high.equals(b.high);
    }

    private boolean less(Key x, Key y) {
        return x.compareTo(y) < 0;
    }

    public String toString() {
        return "[" + this.low + ", " + this.high + "]";
    }

    public static void main(String[] args) {
        int N = Integer.parseInt(args[0]);
        Interval<Integer> a = new Interval<Integer>(5, 17);
        Interval<Integer> b = new Interval<Integer>(5, 17);
        Interval<Integer> c = new Interval<Integer>(5, 18);
        System.out.println(a.equals(b));
        System.out.println(!a.equals(c));
        System.out.println(!b.equals(c));
        Interval<Double> interval = new Interval<Double>(0.0, 1.0);
        int cnt = 0;
        int i = 0;
        while (i < N) {
            Double x = 3.0 * Math.random() - 1.0;
            if (interval.contains(x)) {
                ++cnt;
            }
            ++i;
        }
        System.out.println("fraction = " + 1.0 * (double)cnt / (double)N);
    }
}

