/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.princetontool;

import com.xuarig.princetontool.Interval;
import com.xuarig.princetontool.Interval2D;
import java.util.ArrayList;
import java.util.List;

public class QuadTree<Key extends Comparable, Value> {
    private Node root;

    public void insert(Key x, Key y, Value value) {
        this.root = this.insert(this.root, x, y, value);
    }

    private Node insert(Node h, Key x, Key y, Value value) {
        if (h == null) {
            return new Node(this, x, y, value);
        }
        if (this.less(x, h.x) && this.less(y, h.y)) {
            h.SW = this.insert(h.SW, x, y, value);
        } else if (this.less(x, h.x) && !this.less(y, h.y)) {
            h.NW = this.insert(h.NW, x, y, value);
        } else if (!this.less(x, h.x) && this.less(y, h.y)) {
            h.SE = this.insert(h.SE, x, y, value);
        } else if (!this.less(x, h.x) && !this.less(y, h.y)) {
            h.NE = this.insert(h.NE, x, y, value);
        }
        return h;
    }

    public List<Value> query2D(Interval2D<Key> rect) {
        ArrayList aList = new ArrayList();
        this.query2D(aList, this.root, rect);
        return aList;
    }

    private void query2D(List<Value> aList, Node h, Interval2D<Key> rect) {
        if (h == null) {
            return;
        }
        Object xmin = rect.intervalX.low;
        Object ymin = rect.intervalY.low;
        Object xmax = rect.intervalX.high;
        Object ymax = rect.intervalY.high;
        if (rect.contains(h.x, h.y)) {
            aList.add(h.value);
        }
        if (this.less(xmin, h.x) && this.less(ymin, h.y)) {
            this.query2D(aList, h.SW, rect);
        }
        if (this.less(xmin, h.x) && !this.less(ymax, h.y)) {
            this.query2D(aList, h.NW, rect);
        }
        if (!this.less(xmax, h.x) && this.less(ymin, h.y)) {
            this.query2D(aList, h.SE, rect);
        }
        if (!this.less(xmax, h.x) && !this.less(ymax, h.y)) {
            this.query2D(aList, h.NE, rect);
        }
    }

    private boolean less(Key k1, Key k2) {
        return k1.compareTo(k2) < 0;
    }

    private boolean eq(Key k1, Key k2) {
        return k1.compareTo(k2) == 0;
    }

    public static void main(String[] args) {
        int M = 30;
        int N = 5000;
        QuadTree<Integer, String> st = new QuadTree<Integer, String>();
        int i = 0;
        while (i < N) {
            Integer x = (int)(100.0 * Math.random());
            Integer y = (int)(100.0 * Math.random());
            st.insert(x, y, "P" + i);
            ++i;
        }
        System.out.println("Done preprocessing " + N + " points");
        i = 0;
        while (i < M) {
            Integer xmin = (int)(100.0 * Math.random());
            Integer ymin = (int)(100.0 * Math.random());
            Integer xmax = xmin + (int)(10.0 * Math.random());
            Integer ymax = ymin + (int)(20.0 * Math.random());
            Interval<Integer> intX = new Interval<Integer>(xmin, xmax);
            Interval<Integer> intY = new Interval<Integer>(ymin, ymax);
            Interval2D<Integer> rect = new Interval2D<Integer>(intX, intY);
            System.out.println(rect + " : ");
            List aList = st.query2D(rect);
            for (String aString : aList) {
                System.out.println(aString);
            }
            ++i;
        }
    }

    private static class Node {
        Key x;
        Key y;
        Node NW;
        Node NE;
        Node SE;
        Node SW;
        Value value;
        final /* synthetic */ QuadTree this$0;

        Node(Key x, Key y, Value value) {
            this.this$0 = var1_1;
            this.x = x;
            this.y = y;
            this.value = value;
        }
    }
}

