/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.tool;

import com.xuarig.tool.Observer;
import java.util.ArrayList;
import java.util.List;

public abstract class Observable {
    Change theChange;
    String theChangeContext = null;
    private List<Observer> theObservers = new ArrayList<Observer>();
    private boolean isBeingNotified = false;
    private List<Observer> theObserversRemovedDelayed = new ArrayList<Observer>();
    private List<Observer> theObserversAddedDelayed = new ArrayList<Observer>();

    public void addObserver(Observer aObserver) {
        if (!this.isBeingNotified) {
            this.theObservers.add(aObserver);
            return;
        }
        if (this.theObserversAddedDelayed == null) {
            this.theObserversAddedDelayed = new ArrayList<Observer>();
        }
        this.theObserversAddedDelayed.add(aObserver);
    }

    public void removeObserver(Observer aObserver) {
        if (!this.isBeingNotified) {
            this.theObservers.remove(aObserver);
            return;
        }
        if (this.theObservers.contains(aObserver)) {
            if (this.theObserversRemovedDelayed == null) {
                this.theObserversRemovedDelayed = new ArrayList<Observer>();
            }
            this.theObserversRemovedDelayed.add(aObserver);
        }
    }

    public void setChanged(Change aChange) {
        this.theChange = aChange;
        this.theChangeContext = null;
    }

    public void setChanged(Change aChange, String aChangeContext) {
        this.setChanged(aChange);
        this.theChangeContext = aChangeContext;
    }

    public Change getChange() {
        return this.theChange;
    }

    public String getChangeContext() {
        return this.theChangeContext;
    }

    private void cleanupObservers() {
        if (this.theObserversAddedDelayed != null) {
            for (Observer aObserver : this.theObserversAddedDelayed) {
                this.theObservers.add(aObserver);
            }
            this.theObserversAddedDelayed = null;
        }
        if (this.theObserversRemovedDelayed != null) {
            for (Observer aObserver : this.theObserversRemovedDelayed) {
                this.theObservers.remove(aObserver);
            }
            this.theObserversRemovedDelayed = null;
        }
    }

    public void notifyObservers() {
        this.isBeingNotified = true;
        for (Observer aObserver : this.theObservers) {
            aObserver.update(this, this.getChange());
        }
        this.cleanupObservers();
        this.isBeingNotified = false;
    }

    public static enum Change {
        CREATED,
        CHANGED,
        CORECHANGED,
        INDELETION,
        INITOBSERVER;

    }
}

