/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.tool;

import com.xuarig.tool.Observable;
import com.xuarig.tool.Observer;
import com.xuarig.tool.ViewForRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JMenuItem;

public abstract class Renderer
implements Observer {
    ViewForRenderer theView;
    protected int theX;
    protected int theY;
    protected int theXCentre = 0;
    protected int theYCentre = 0;
    protected double theXPlan = 0.0;
    protected double theYPlan = 0.0;
    protected double theXPlanCentre = 0.0;
    protected double theYPlanCentre = 0.0;
    protected double theScale = 1.0;
    protected int theSelectionBorder = 2;
    protected double theRadius = 8.0;
    protected int theEpsilon = 1;
    protected int theDrawingPriority = 0;
    protected boolean isDraggable = false;
    protected int thePhantomX;
    protected int thePhantomY;
    protected boolean hasPhantom = false;
    protected boolean isSelected = false;
    protected boolean isConnectable = false;
    protected boolean isAlive = true;

    public boolean isAlive() {
        return this.isAlive;
    }

    public void kill() {
        this.isAlive = false;
    }

    public void setView(ViewForRenderer aView) {
        this.theView = aView;
    }

    public int getDrawingPriority() {
        return this.theDrawingPriority;
    }

    public void setDrawingPriority(int aPriority) {
        this.theDrawingPriority = aPriority;
    }

    public void computeDrawingPriority(Graphics g) {
    }

    public void changeProjection(int aXCentre, int aYCentre, double aXPlanCentre, double aYPlanCentre, double aScale) {
        this.theXCentre = aXCentre;
        this.theYCentre = aYCentre;
        this.theXPlanCentre = aXPlanCentre;
        this.theYPlanCentre = aYPlanCentre;
        this.theScale = aScale;
        this.computeProjection();
    }

    protected void computeProjection() {
        this.theX = (int)(this.theScale * (this.theXPlan - this.theXPlanCentre)) + this.theXCentre;
        this.theY = (int)(this.theScale * (this.theYPlan - this.theYPlanCentre)) + this.theYCentre;
    }

    public int getX() {
        return this.theX;
    }

    public int getY() {
        return this.theY;
    }

    public double getXPlan() {
        return this.theXPlan;
    }

    public double getYPlan() {
        return this.theYPlan;
    }

    public void showPhantom(int aX, int aY) {
        this.hasPhantom = true;
        this.thePhantomX = aX;
        this.thePhantomY = aY;
    }

    public void hidePhantom() {
        this.hasPhantom = false;
    }

    public boolean hasPhantom() {
        return this.hasPhantom;
    }

    public int getPhantomX() {
        return this.thePhantomX;
    }

    public int getPhantomY() {
        return this.thePhantomY;
    }

    public boolean isDraggable() {
        return this.isDraggable;
    }

    public boolean isConnectable() {
        return this.isConnectable;
    }

    public void showSelected() {
        this.isSelected = true;
    }

    public void showDeselected() {
        this.isSelected = false;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void Paint(Graphics g) {
        g.setColor(Color.darkGray);
        g.fillOval(this.theX - (int)this.theRadius, this.theY - (int)this.theRadius, (int)this.theRadius * 2, (int)this.theRadius * 2);
    }

    public boolean isIn(int aX, int aY) {
        if ((double)aX < (double)this.theX - this.theRadius) {
            return false;
        }
        if ((double)aX > (double)this.theX + this.theRadius) {
            return false;
        }
        if ((double)aY > (double)this.theY + this.theRadius) {
            return false;
        }
        return !((double)aY < (double)this.theY - this.theRadius);
    }

    @Override
    public void update(Observable aUpdated, Observable.Change aChange) {
        if (aChange == Observable.Change.INDELETION) {
            this.removeFromView();
        }
    }

    public boolean isFriend(Renderer aRenderer) {
        return false;
    }

    protected void removeFromView() {
        if (this.theView != null) {
            this.theView.removeRenderer(this);
        }
    }

    public ViewForRenderer getView() {
        return this.theView;
    }

    public void Dump() {
        System.out.println("___________________________________");
        System.out.println("Dump Renderer / X:" + this.getX() + " Y:" + this.getY());
    }

    public abstract String getKey();

    protected abstract String makeConnectedKey(Renderer var1);

    public abstract List<JMenuItem> getMenuSimple();

    public abstract List<JMenuItem> getMenuMultiple();
}

