/*
 * Decompiled with CFR 0.152.
 */
package com.xuarig.tool;

import com.xuarig.tool.Observable;
import com.xuarig.tool.Renderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class RendererConnector
extends Renderer {
    Renderer theRendererA;
    Renderer theRendererB;

    public RendererConnector(Renderer aRendererA, Renderer aRendererB) {
        this.theRendererA = aRendererA;
        this.theRendererB = aRendererB;
    }

    public Renderer getRendererA() {
        return this.theRendererA;
    }

    public Renderer getRendererB() {
        return this.theRendererB;
    }

    public void completeRendererB(Renderer aRenderer) {
        this.theRendererB = aRenderer;
    }

    @Override
    public int getX() {
        return this.theRendererA.getX();
    }

    @Override
    public int getY() {
        return this.theRendererA.getY();
    }

    @Override
    public void Paint(Graphics g) {
        if (this.theRendererB != null) {
            Stroke aS;
            Graphics2D g2 = (Graphics2D)g;
            if (this.isSelected()) {
                aS = g2.getStroke();
                g2.setStroke(new BasicStroke(3.0f));
                g.setColor(Color.lightGray);
                g.drawLine(this.theRendererA.getX(), this.theRendererA.getY(), this.theRendererB.getX(), this.theRendererB.getY());
                g2.setStroke(aS);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            aS = g2.getStroke();
            g2.setStroke(new BasicStroke(1.0f));
            Color aColor = new Color(20, 20, 20, 70);
            g2.setColor(aColor);
            g2.drawLine(this.theRendererA.getX(), this.theRendererA.getY(), this.theRendererB.getX(), this.theRendererB.getY());
            g2.setStroke(aS);
        }
        if (this.hasPhantom()) {
            g.setColor(Color.lightGray);
            g.drawLine(this.theRendererA.getX(), this.theRendererA.getY(), this.getPhantomX(), this.getPhantomY());
        }
    }

    @Override
    public boolean isIn(int aX, int aY) {
        if (this.theRendererB == null) {
            return false;
        }
        int aXA = this.theRendererA.getX();
        int aYA = this.theRendererA.getY();
        int aXB = this.theRendererB.getX();
        int aYB = this.theRendererB.getY();
        if (aXA == aXB) {
            return Math.abs(aXA - aX) <= this.theEpsilon;
        }
        if (aYA == aYB) {
            return Math.abs(aYA - aY) <= this.theEpsilon;
        }
        double aXJ = (double)(aXB - aXA) / (double)(aYB - aYA) * (double)(aY - aYA) + (double)aXA;
        double aYI = (double)(aYB - aYA) / (double)(aXB - aXA) * (double)(aX - aXA) + (double)aYA;
        return Math.abs(aXJ - (double)aX) < (double)this.theEpsilon || Math.abs(aYI - (double)aY) < (double)this.theEpsilon;
    }

    @Override
    public void update(Observable aUpdated, Observable.Change aChange) {
        if (aChange == Observable.Change.CHANGED && aUpdated.getChangeContext() == "LostFriend" && !this.theRendererA.isFriend(this.theRendererB)) {
            this.kill();
            this.removeFromView();
        }
        super.update(aUpdated, aChange);
    }

    @Override
    public String getKey() {
        return this.theRendererA.makeConnectedKey(this.theRendererB);
    }

    @Override
    protected String makeConnectedKey(Renderer aRendererB) {
        String aKey = "Fatal Error";
        return aKey;
    }

    @Override
    public List<JMenuItem> getMenuMultiple() {
        ArrayList<JMenuItem> aListMenu = new ArrayList<JMenuItem>();
        JMenuItem aMenu = new JMenuItem("Delete");
        aMenu.setName("Delete");
        aListMenu.add(aMenu);
        return aListMenu;
    }

    @Override
    public List<JMenuItem> getMenuSimple() {
        return this.getMenuMultiple();
    }
}

